/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.net.UnknownHostException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceHostUI
extends AbstractChangeable
implements SelectionListener,
ModifyListener {
    private Button _delete;
    private Button _add;
    private Button _testConnection;
    private Text _host;
    private Text _port;
    private Table _list;
    private WizardPage _wizardPage = null;

    public TraceHostUI(WizardPage wizardPage) {
        this.setWizardPage(wizardPage);
    }

    public TraceHostUI() {
    }

    private boolean checkPortNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "Invalid port number " + string;
            Status status = new Status(2, "org.eclipse.core.resources", 566, string2, null);
            ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("STR_HYADES_MSG"), (String)"", (IStatus)status);
            return false;
        }
    }

    public void addHost() {
        if (this.checkPortNumber(this._port.getText().trim())) {
            this.addHost(this._host.getText().trim() + ":" + this._port.getText().trim());
            this._host.setText("");
            this._port.setText(String.valueOf(10002));
            this._host.setFocus();
        } else {
            this._port.setSelection(0, this._port.getText().length());
            this._port.setFocus();
        }
    }

    public void addHost(String string) {
        int n = 0;
        while (n < this._list.getItemCount()) {
            if (string.equals(this._list.getItem(n).getText())) {
                return;
            }
            ++n;
        }
        TableItem tableItem = new TableItem(this._list, 0);
        tableItem.setText(string);
        tableItem.setImage(PDPluginImages.getImage("node_obj.gif"));
        this._list.setSelection(new TableItem[]{tableItem});
    }

    private void addHosts(String string) {
        if (string != null && !string.equals("")) {
            int n = 0;
            while (n != -1) {
                n = string.indexOf(",");
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    this.addHost(string2);
                    string = string.substring(n + 1);
                    continue;
                }
                this.addHost(string);
            }
        }
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(UIPlugin.getResourceString("STR_PREF_HOST_NODE"));
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        composite3.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        composite3.setLayoutData((Object)gridData);
        this._list = new Table(composite3, 2304);
        gridData = GridUtil.createFill();
        this._list.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        gridData = new GridData();
        composite4.setLayoutData((Object)GridUtil.createHorizontalFill());
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        Label label2 = new Label(composite4, 0);
        label2.setText(UIPlugin.getResourceString("STR_PREF_HOST_IP"));
        this._host = new Text(composite4, 2048);
        this._host.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label3 = new Label(composite4, 0);
        label3.setText(UIPlugin.getResourceString("RAC_PORT_TEXT"));
        this._port = new Text(composite4, 2048);
        this._port.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._port.setText(String.valueOf(10002));
        Composite composite5 = new Composite(composite2, 0);
        gridData = GridUtil.createVerticalFill();
        composite5.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite5.setLayout((Layout)gridLayout);
        Composite composite6 = new Composite(composite5, 0);
        gridData = GridUtil.createFill();
        composite6.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite6.setLayout((Layout)gridLayout);
        this._delete = new Button(composite6, 0);
        this._delete.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._delete.setText(UIPlugin.getResourceString("DELETE"));
        this._testConnection = new Button(composite6, 0);
        this._testConnection.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._testConnection.setText(UIPlugin.getResourceString("TEST_CONNECTION_TEXT"));
        Label label4 = new Label(composite6, 0);
        label4.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite composite7 = new Composite(composite5, 0);
        gridData = GridUtil.createHorizontalFill();
        composite7.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite7.setLayout((Layout)gridLayout);
        this._add = new Button(composite7, 0);
        this._add.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._add.setText(UIPlugin.getResourceString("STR_PREF_ADD"));
        this._add.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._testConnection.addSelectionListener((SelectionListener)this);
        this._list.addSelectionListener((SelectionListener)this);
        this._host.addModifyListener((ModifyListener)this);
        this._port.addModifyListener((ModifyListener)this);
        this._add.setEnabled(false);
        this._delete.setEnabled(false);
        this._testConnection.setEnabled(false);
        this.initializeValues();
        this._host.setFocus();
        this._host.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    if (TraceHostUI.this._host.getText().trim() == "" || TraceHostUI.this._port.getText().trim() == "") {
                        return;
                    }
                    TraceHostUI.this.addHost();
                    traverseEvent.doit = false;
                    if (TraceHostUI.this._wizardPage != null) {
                        TraceHostUI.this._wizardPage.setPageComplete(TraceHostUI.this._list.getSelectionIndex() != -1);
                    }
                }
            }
        });
        WorkbenchHelp.setHelp((Control)this._list, (String)(UIPlugin.getPluginId() + ".hstp0001"));
        WorkbenchHelp.setHelp((Control)this._host, (String)(UIPlugin.getPluginId() + ".hstp0002"));
        WorkbenchHelp.setHelp((Control)this._delete, (String)(UIPlugin.getPluginId() + ".hstp0003"));
        WorkbenchHelp.setHelp((Control)this._add, (String)(UIPlugin.getPluginId() + ".hstp0004"));
        WorkbenchHelp.setHelp((Control)this._testConnection, (String)(UIPlugin.getPluginId() + ".hstp0005"));
        WorkbenchHelp.setHelp((Control)this._port, (String)(UIPlugin.getPluginId() + ".hstp0006"));
        return composite2;
    }

    public Table getListUI() {
        return this._list;
    }

    public Text getHostUI() {
        return this._host;
    }

    public Text getPortUI() {
        return this._port;
    }

    public Button getDeleteUI() {
        return this._delete;
    }

    public Button getAddUI() {
        return this._add;
    }

    public WizardPage getWizardPage() {
        return this._wizardPage;
    }

    public void setWizardPage(WizardPage wizardPage) {
        this._wizardPage = wizardPage;
    }

    private void deleteHost() {
        int n = this._list.getSelectionIndex();
        if (n != -1) {
            this._list.remove(n);
        }
    }

    private void testConnection() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                TableItem tableItem;
                String string;
                int n = TraceHostUI.this._list.getSelectionIndex();
                if (n != -1 && (string = (tableItem = TraceHostUI.this._list.getItem(n)).getText()) != null && !string.equals("")) {
                    int n2 = 0;
                    n2 = string.indexOf(":");
                    if (n2 != -1) {
                        String string2 = string.substring(0, n2);
                        String string3 = string.substring(n2 + 1);
                        HyadesUtil.testConnection(string2, string3, true, TraceHostUI.this._list.getShell());
                    }
                }
            }
        });
    }

    public String getHost() {
        String string = null;
        int n = this._list.getSelectionIndex();
        if (n == -1) {
            return string;
        }
        string = this._list.getItem(n).getText();
        int n2 = string.indexOf(":");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public int getPort() {
        int n;
        String string = String.valueOf(10002);
        int n2 = this._list.getSelectionIndex();
        if (n2 != -1) {
            string = this._list.getItem(n2).getText();
        }
        string = (n = string.indexOf(":")) != -1 ? string.substring(n + 1) : String.valueOf(10002);
        return Integer.parseInt(string);
    }

    public boolean isLocalHost(String string) {
        String string2 = "localhost";
        if (string2.equals(string)) {
            return true;
        }
        try {
            Node node = NodeFactory.createNode((String)string2);
            string2 = node.getInetAddress().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return string.equals(string2);
    }

    public TableItem[] getHosts() {
        return this._list.getItems();
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("use_host");
        this.addHosts(string);
        this.enableButtons();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        block4: {
            block3: {
                if (modifyEvent.widget != this._host) break block3;
                this._add.setEnabled(!this._host.getText().trim().equals("") && !this._port.getText().trim().equals(""));
                break block4;
            }
            if (modifyEvent.widget != this._port) break block4;
            try {
                int n = Integer.parseInt(this._port.getText().trim());
                if (n < 0) {
                    this._add.setEnabled(false);
                    return;
                }
                this._add.setEnabled(!this._host.getText().trim().equals("") && !this._port.getText().trim().equals(""));
            }
            catch (NumberFormatException numberFormatException) {
                this._add.setEnabled(false);
            }
        }
    }

    public void reset() {
        this._list.removeAll();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._list && this._wizardPage != null && this._wizardPage.getNextPage() != null) {
            this._wizardPage.getWizard().getContainer().showPage(this._wizardPage.getNextPage());
        }
    }

    private void enableButtons() {
        this._delete.setEnabled(this._list.getSelectionIndex() != -1);
        this._testConnection.setEnabled(this._list.getSelectionIndex() != -1 && this._list.getSelectionCount() == 1);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._add) {
            this.addHost();
            this.enableButtons();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (selectionEvent.widget == this._delete) {
            this.deleteHost();
            this.enableButtons();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (selectionEvent.widget == this._list) {
            TableItem[] tableItemArray = this._list.getSelection();
            this.enableButtons();
            this._list.setSelection(tableItemArray);
            this.changed();
            if (this._wizardPage != null) {
                this._wizardPage.setPageComplete(this._list.getSelectionIndex() != -1);
            }
        } else if (selectionEvent.widget == this._testConnection) {
            this.testConnection();
            this.enableButtons();
            this._testConnection.setFocus();
        }
    }

    public void selectHost(String string) {
        int n = 0;
        while (n < this._list.getItemCount()) {
            if (string.equals(this._list.getItem(n).getText())) {
                this._list.setSelection(n);
                return;
            }
            ++n;
        }
    }
}

