/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProfileAgentsTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfiguration _conf;
    private DoubleCTree _list;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(composite2, 1);
        this._list = new DoubleCTree(composite2, 0, UIPlugin.getResourceString("STR_LIST_AGENTS"), UIPlugin.getResourceString("STR_LIST_SOURCE"), UIPlugin.getResourceString("STR_LIST_TARGET"));
        this._list.addListener(new Listener(){

            public void handleEvent(Event event) {
                ProfileAgentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText(UIPlugin.getResourceString("RESET_DATA"));
        button.setToolTipText(UIPlugin.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProfileAgentsTab.this._list.initialize(new Vector(ProfileAttachDelegate.getNodeConfiguration(ProfileAgentsTab.this._conf)).elements(), false);
            }
        });
        WorkbenchHelp.setHelp((Control)this._list.getControl(), (String)(UIPlugin.getPluginId() + ".atlp0002"));
        WorkbenchHelp.setHelp((Control)button, (String)(UIPlugin.getPluginId() + ".atlp0000"));
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".atlp0002"));
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this._list.getSelectedAgents().size() == 0) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this._conf = iLaunchConfiguration;
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                List list = ProfileAttachDelegate.getNodeConfiguration(ProfileAgentsTab.this._conf);
                List list2 = ProfileAttachDelegate.getAgents(ProfileAgentsTab.this._conf, list);
                if (list2.size() == 0) {
                    ProfileAgentsTab.this._list.removeAll();
                }
                ProfileAgentsTab.this._list.setSelectedAgents(new Vector(list2));
                ProfileAgentsTab.this._list.initialize(new Vector(list).elements(), false);
            }
        });
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = this._list.getTargetItems();
        int n = 0;
        while (n < vector.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                TreeItem treeItem = (TreeItem)vector.get(n);
                Process process = (Process)treeItem.getData();
                stringBuffer.append(process.getProcessId());
                stringBuffer.append(':');
                TreeItem[] treeItemArray = treeItem.getItems();
                int n2 = 0;
                while (n2 < treeItemArray.length) {
                    Agent agent = (Agent)treeItemArray[n2].getData();
                    stringBuffer.append(agent.getName());
                    if (n2 < treeItemArray.length) {
                        stringBuffer.append(',');
                    }
                    ++n2;
                }
            }
            catch (InactiveProcessException inactiveProcessException) {
                inactiveProcessException.printStackTrace();
            }
            arrayList.add(stringBuffer.toString());
            ++n;
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, arrayList);
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_AGENTS");
    }

    public Image getImage() {
        return PDPluginImages.getImage("agent_obj.gif");
    }

    void reset() {
        this._list.removeAll();
    }
}

