/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFileUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProfileDestinationTab {
    private TraceLocationUI _destinationUI = new TraceLocationUI();
    private TraceFileUI _fileUI = new TraceFileUI();
    private ProfileTab parentTab;

    public ProfileDestinationTab(ProfileTab profileTab) {
        this.parentTab = profileTab;
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridUtil.createFill());
        this._destinationUI.createControl(composite2);
        this._fileUI.createControl(composite2);
        if (!UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option")) {
            this._fileUI.setVisible(false);
        }
        return composite2;
    }

    public void addListener(Listener listener) {
        this._destinationUI.addListener(listener);
        this._fileUI.addListener(listener);
    }

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
            String string = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, "");
            String string2 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, "");
            String string3 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, "");
            boolean bl = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
            if (string.length() == 0) {
                string = iPreferenceStore.getString("prj_name");
            }
            if (string2.length() == 0) {
                string2 = iPreferenceStore.getString("mon_name");
            }
            this._destinationUI.setLocation(string);
            this._destinationUI.setMonitor(string2);
            this._fileUI.setFile(string3);
            this._fileUI.setEnabled(bl);
            this._fileUI.getExternalBox().setSelection(bl);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, this._destinationUI.getLocation().getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, this._destinationUI.getMonitor().getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, this._fileUI.getExternalBox().getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, this._fileUI.getFile());
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.parentTab.setErrorMessage(null);
        this.parentTab.setMessage(null);
        if (this._destinationUI.getLocation().getText().trim().length() == 0) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_PROJECT"));
            return false;
        }
        if (this._destinationUI.getMonitor().getText().trim().length() == 0) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_MONITOR"));
            return false;
        }
        if (this._fileUI.getSelection() && this._fileUI.getFile().trim().length() == 0) {
            this.parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_FILE"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, iPreferenceStore.getString("prj_name"));
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, iPreferenceStore.getString("mon_name"));
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null);
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
    }
}

