/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAgentsTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProfileHostTab
extends AbstractLaunchConfigurationTab {
    private TraceHostUI _ui;
    private ProfileAgentsTab _agents;
    private String _oldHost;
    private int _oldPort = -1;

    public ProfileHostTab() {
        this(null);
    }

    public ProfileHostTab(ProfileAgentsTab profileAgentsTab) {
        this._agents = profileAgentsTab;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(composite2, 1);
        this._ui = new TraceHostUI();
        this._ui.createControl(composite2);
        this._ui.addListener(new Listener(){

            public void handleEvent(Event event) {
                String string = ProfileHostTab.this._ui.getHost();
                int n = ProfileHostTab.this._ui.getPort();
                if (!(ProfileHostTab.this._agents == null || ProfileHostTab.this._oldPort == -1 || ProfileHostTab.this._oldHost == null || ProfileHostTab.this._oldHost.equals(string) && ProfileHostTab.this._oldPort == n)) {
                    ProfileHostTab.this._agents.reset();
                }
                ProfileHostTab.this._oldHost = string;
                ProfileHostTab.this._oldPort = n;
                ProfileHostTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this._ui.getHost() == null) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_HOST"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, iPreferenceStore.getDefaultInt("localhost_port"));
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        try {
            String string = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int n = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, iPreferenceStore.getDefaultInt("localhost_port"));
            String string2 = string + ":" + n;
            this._ui.addHost(string2);
            this._ui.selectHost(string2);
            this._oldHost = string;
            this._oldPort = n;
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, this._ui.getHost());
        iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, this._ui.getPort());
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_HOST");
    }

    public Image getImage() {
        return PDPluginImages.getImage("node_obj.gif");
    }

    public boolean isLocal() {
        return this._ui.isLocalHost(this._ui.getHost());
    }
}

