/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class HostPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceHostUI _options;

    public HostPreferencePage() {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    private void addHosts(String string) {
        if (string != null && !string.equals("")) {
            int n = 0;
            while (n != -1) {
                n = string.indexOf(",");
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    this._options.addHost(string2);
                    string = string.substring(n + 1);
                    continue;
                }
                this._options.addHost(string);
            }
        }
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".hstp0000"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this._options = new TraceHostUI();
        this._options.createControl(composite2);
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this._options.reset();
        String string = iPreferenceStore.getDefaultString("use_host");
        this.addHosts(string);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        String string = "";
        TableItem[] tableItemArray = this._options.getHosts();
        int n = 0;
        while (n < tableItemArray.length) {
            string = string + "," + tableItemArray[n].getText().trim();
            ++n;
        }
        if (string.startsWith(",") && string.length() > 1) {
            string = string.substring(1);
        }
        iPreferenceStore.setValue("use_host", string);
    }
}

