/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.hyades.trace.ui.internal.util.FilterListContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.TableViewer;

public class FilterList
implements IBasicPropertyConstants {
    ArrayList filters = new ArrayList();
    TableViewer fViewer;
    private List listeners;

    public FilterList(TableViewer tableViewer) {
        this.fViewer = tableViewer;
    }

    public void add(FilterTableElement filterTableElement) {
        this.add(filterTableElement, -1);
    }

    public void add(FilterTableElement filterTableElement, int n) {
        if (n < 0) {
            this.filters.add(filterTableElement);
        } else {
            this.filters.add(n, filterTableElement);
        }
    }

    public void addElementChangedListener(FilterListContentProvider filterListContentProvider) {
        if (filterListContentProvider == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(filterListContentProvider)) {
            this.listeners.add(filterListContentProvider);
        }
    }

    public Object[] elements() {
        return this.filters.toArray();
    }

    public void fireElementChanged(FilterTableElement filterTableElement, String string) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                FilterListContentProvider filterListContentProvider = (FilterListContentProvider)iterator.next();
                filterListContentProvider.elementChanged(filterTableElement, string);
            }
        }
    }

    public Object getElementAt(int n) {
        return this.filters.get(n);
    }

    public ArrayList getFilters() {
        return (ArrayList)this.filters.clone();
    }

    public int getSize() {
        return this.filters.size();
    }

    public void removeAll() {
        this.filters.clear();
    }

    public void removeElements(int[] nArray) {
        if (nArray == null) {
            return;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != -1) {
                Object e = this.filters.get(nArray[n]);
                vector.add(e);
            }
            ++n;
        }
        this.filters.removeAll(vector);
    }

    public Object removeElementAt(int n) {
        Object e = this.filters.get(n);
        if (e == null) {
            return null;
        }
        this.filters.remove(e);
        return e;
    }

    public void removeElementChangedListener(FilterListContentProvider filterListContentProvider) {
        if (this.listeners != null) {
            this.listeners.remove(filterListContentProvider);
        }
    }

    public Object[] uiElements() {
        return this.filters.toArray();
    }
}

