/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveUtil {
    private static final String MONITOR = UIPlugin.getResourceString("SAVE_MONITOR_TEXT");
    private static final String NODE = UIPlugin.getResourceString("SAVE_NODE_TEXT");
    private static final String PROCESS = UIPlugin.getResourceString("SAVE_PROCESS_TEXT");
    private static final String AGENT = UIPlugin.getResourceString("SAVE_AGENT_TEXT");
    private static final String CORRELATION = UIPlugin.getResourceString("SAVE_CORRELATION_TEXT");

    public static void save(Collection collection, IProgressMonitor iProgressMonitor, String string) {
        Collection collection2 = SaveUtil.findItems(collection, string);
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(UIPlugin.getResourceString("SAVE"), collection2.size());
        }
        if (SaveUtil.isValid(collection2)) {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                SaveUtil.saveItem(iterator.next(), iProgressMonitor);
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) break;
            }
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    public static void saveItem(Object object, IProgressMonitor iProgressMonitor) {
        if (object instanceof EObject) {
            CorrelationContainerProxy correlationContainerProxy;
            EObject eObject = (EObject)object;
            if (object instanceof TRCMonitor) {
                try {
                    org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)eObject.eResource());
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(MONITOR, ((TRCMonitor)object).getName(), eObject);
                }
            } else if (object instanceof TRCNode) {
                try {
                    org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)eObject.eResource());
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(NODE, ((TRCNode)object).getName(), eObject);
                }
            } else if (object instanceof TRCProcessProxy) {
                try {
                    org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)eObject.eResource());
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(PROCESS, ((TRCProcessProxy)object).getName(), eObject);
                }
            } else if (object instanceof TRCAgentProxy) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object;
                if (tRCAgentProxy.getAgent() != null) {
                    try {
                        org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCAgentProxy.getAgent().eResource());
                    }
                    catch (Exception exception) {
                        SaveUtil.handleSaveException(AGENT, tRCAgentProxy.getName(), (EObject)tRCAgentProxy);
                    }
                }
            } else if (object instanceof CorrelationContainerProxy && (correlationContainerProxy = (CorrelationContainerProxy)object).getCorrelationContainer() != null) {
                try {
                    org.eclipse.hyades.models.hierarchy.util.SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)correlationContainerProxy.getCorrelationContainer().eResource());
                }
                catch (Exception exception) {
                    SaveUtil.handleSaveException(CORRELATION, correlationContainerProxy.getName(), eObject);
                }
            }
        } else if (object instanceof INavigatorItem) {
            INavigatorItem iNavigatorItem;
            if (iProgressMonitor != null) {
                iProgressMonitor.setTaskName(((INavigatorItem)object).getText());
                iProgressMonitor.worked(1);
            }
            if ((iNavigatorItem = (INavigatorItem)object).isSaveEnabled()) {
                iNavigatorItem.save(true);
            }
        }
    }

    private static Collection findItems(Collection collection, String string) {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SaveUtil.findItems(iterator.next(), hashSet, true, true, string);
        }
        return hashSet;
    }

    private static void findItems(Object object, Collection collection, boolean bl, boolean bl2, String string) {
        if (object != null && !collection.contains(object)) {
            if (!(object instanceof IContainer)) {
                collection.add(object);
            }
            if (bl) {
                SaveUtil.findItems(SaveUtil.getParent(object), collection, true, false, string);
            }
            if (bl2) {
                Iterator iterator = SaveUtil.getChildren(object, string).iterator();
                while (iterator.hasNext()) {
                    SaveUtil.findItems(iterator.next(), collection, false, true, string);
                }
            }
        }
    }

    private static Object getParent(Object object) {
        if (object instanceof TRCNode) {
            return ((TRCNode)object).getMonitor();
        }
        if (object instanceof TRCProcessProxy) {
            return ((TRCProcessProxy)object).getNode();
        }
        if (object instanceof TRCAgentProxy) {
            return ((TRCAgentProxy)object).getProcessProxy();
        }
        if (object instanceof CorrelationContainerProxy) {
            return ((CorrelationContainerProxy)object).getMonitor();
        }
        if (object instanceof INavigatorItem) {
            return ((INavigatorItem)object).getParent();
        }
        return null;
    }

    private static Collection getChildren(Object object, String string) {
        HashSet<IResource> hashSet = new HashSet<IResource>();
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            try {
                IResource[] iResourceArray = iContainer.members();
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n] instanceof IContainer) {
                        hashSet.add(iResourceArray[n]);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            hashSet.addAll(PDContentProvider.getMonitors(iContainer));
        } else if (object instanceof TRCMonitor) {
            hashSet.addAll((Collection<IResource>)((TRCMonitor)object).getNodes());
        } else if (object instanceof TRCNode) {
            hashSet.addAll((Collection<IResource>)((TRCNode)object).getProcessProxies());
        } else if (object instanceof TRCProcessProxy) {
            hashSet.addAll((Collection<IResource>)((TRCProcessProxy)object).getAgentProxies());
        } else if (object instanceof CorrelationContainerProxy) {
            hashSet.addAll((Collection<IResource>)((CorrelationContainerProxy)object).getCorrelatedAgents());
        }
        hashSet.addAll(NavigatorExtensionUtil.getAllChildren((Object)object, (String)string));
        return hashSet;
    }

    private static boolean isValid(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (SaveUtil.isValid(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isValid(Object object) {
        if (object instanceof EObject) {
            CorrelationContainerProxy correlationContainerProxy;
            if (object instanceof TRCMonitor) {
                TRCMonitor tRCMonitor = (TRCMonitor)object;
                if (SaveUtil.isReadOnly(tRCMonitor.eResource())) {
                    SaveUtil.handleSaveReadOnlyException(tRCMonitor.getName(), (EObject)tRCMonitor);
                    return false;
                }
            } else if (object instanceof TRCNode) {
                TRCNode tRCNode = (TRCNode)object;
                if (!tRCNode.eIsProxy() && SaveUtil.isReadOnly(tRCNode.eResource())) {
                    SaveUtil.handleSaveReadOnlyException(tRCNode.getName(), (EObject)tRCNode);
                    return false;
                }
            } else if (object instanceof TRCProcessProxy) {
                TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)object;
                if (!tRCProcessProxy.eIsProxy() && SaveUtil.isReadOnly(tRCProcessProxy.eResource())) {
                    SaveUtil.handleSaveReadOnlyException(tRCProcessProxy.getName(), (EObject)tRCProcessProxy);
                    return false;
                }
            } else if (object instanceof TRCAgentProxy) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object;
                if (!tRCAgentProxy.eIsProxy()) {
                    if (SaveUtil.isReadOnly(tRCAgentProxy.getAgent().eResource())) {
                        SaveUtil.handleSaveReadOnlyException(tRCAgentProxy.getName(), (EObject)tRCAgentProxy);
                        return false;
                    }
                    if (tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
                        SaveUtil.handleActiveAgentWhenSave(tRCAgentProxy);
                        return false;
                    }
                }
            } else if (object instanceof CorrelationContainerProxy && SaveUtil.isReadOnly((correlationContainerProxy = (CorrelationContainerProxy)object).getCorrelationContainer().eResource())) {
                SaveUtil.handleSaveReadOnlyException(correlationContainerProxy.getName(), (EObject)correlationContainerProxy);
                return false;
            }
        }
        return true;
    }

    private static boolean isReadOnly(Resource resource) {
        Path path = new Path(resource.getURI().toString());
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (iResource != null && iResource.isAccessible()) {
            return iResource.isReadOnly();
        }
        return false;
    }

    private static void handleActiveAgentWhenSave(TRCAgentProxy tRCAgentProxy) {
        if (tRCAgentProxy.getAgent() == null) {
            return;
        }
        Resource resource = tRCAgentProxy.getAgent().eResource();
        String string = UIPlugin.getResourceString("SAVE_ACTIVE_AGENT_ERROR_");
        string = HyadesUtil.change(string, "%1", tRCAgentProxy.getName());
        final Shell shell = UIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string, null);
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("SAVE_FILE_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }

    private static void handleSaveException(String string, String string2, EObject eObject) {
        Resource resource = eObject.eResource();
        String string3 = UIPlugin.getResourceString("SAVE_FILE_ERROR_");
        string3 = TString.change(string3, "%1", string);
        string3 = resource != null ? TString.change(string3, "%2", resource.getURI().toString()) : TString.change(string3, "%2", string2);
        final Shell shell = UIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string3, null);
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("SAVE_FILE_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }

    private static void handleSaveReadOnlyException(String string, EObject eObject) {
        Shell shell;
        Resource resource = eObject.eResource();
        String string2 = UIPlugin.getResourceString("SAVE_READ_ONLY_FILE_ERROR_");
        if (resource != null) {
            string2 = TString.change(string2, "%2", resource.getURI().toString());
        }
        if (string != null) {
            string2 = TString.change(string2, "%1", string);
        }
        if ((shell = UIPlugin.getActiveWorkbenchShell()) != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string2, null);
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("SAVE_FILE_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }
}

