/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFileUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProfAgentFolderPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    protected PDProjectExplorer fViewer;
    private String location;
    private String monitor;
    private TraceFileUI _fileUI;
    private TraceLocationUI _locationUI;

    public OpenProfAgentFolderPage(String string, PDProjectExplorer pDProjectExplorer) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("STR_DEST_MON_PAGE"));
        this.setDescription(UIPlugin.getResourceString("STR_DEST_MON_DESC"));
        this.fViewer = pDProjectExplorer;
    }

    public String getFile() {
        return this._fileUI.getSelection() ? this._fileUI.getFile() : "";
    }

    public String getMonitor() {
        return this.monitor;
    }

    public String getProject() {
        return this.location;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(composite2);
        this._locationUI.setEnabled(false);
        this._fileUI = new TraceFileUI();
        this._fileUI.createControl(composite2);
        this._fileUI.getExternalBox().addSelectionListener((SelectionListener)this);
        this._fileUI.getFileText().addModifyListener((ModifyListener)this);
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive() || tRCAgentProxy.isActive() && tRCAgentProxy.isAttached()) {
            this._fileUI.setEnabled(false);
            this._fileUI.getExternalBox().setEnabled(false);
        }
        this.setControl((Control)composite2);
        this.populateData();
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".opaf0000"));
    }

    public boolean finish() {
        XMLTraceDataProcessor xMLTraceDataProcessor;
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive()) {
            return true;
        }
        if (this._fileUI.getExternalBox().getSelection()) {
            tRCAgentProxy.setProfileFile(this._fileUI.getFile());
        } else {
            tRCAgentProxy.setProfileFile(null);
        }
        if (tRCAgentProxy.isMonitored() && tRCAgentProxy.isToProfileFile() && (xMLTraceDataProcessor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)tRCAgentProxy)) != null) {
            File file;
            String string = xMLTraceDataProcessor.getProfileFileName();
            File file2 = new File(string);
            boolean bl = true;
            if (tRCAgentProxy.getProfileFile() != null && (file = new File(tRCAgentProxy.getProfileFile())).exists()) {
                bl = false;
            }
            if (file2 == null && tRCAgentProxy.getProfileFile() != null) {
                xMLTraceDataProcessor.setProfileFileName(tRCAgentProxy.getProfileFile());
                xMLTraceDataProcessor.createWriter();
                bl = xMLTraceDataProcessor.isNewProfileFile();
                if (bl) {
                    xMLTraceDataProcessor.writeXMLVersion(xMLTraceDataProcessor.getWriter());
                    xMLTraceDataProcessor.startTrace(xMLTraceDataProcessor.getWriter());
                }
            } else if (!(string == null || string.equals(tRCAgentProxy.getProfileFile()) && file2.exists())) {
                if (file2.exists()) {
                    xMLTraceDataProcessor.endTrace(xMLTraceDataProcessor.getWriter());
                }
                xMLTraceDataProcessor.setProfileFileName(tRCAgentProxy.getProfileFile());
                xMLTraceDataProcessor.createWriter();
                bl = xMLTraceDataProcessor.isNewProfileFile();
                if (bl) {
                    xMLTraceDataProcessor.writeXMLVersion(xMLTraceDataProcessor.getWriter());
                    xMLTraceDataProcessor.startTrace(xMLTraceDataProcessor.getWriter());
                }
            }
        }
        return true;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.checkPageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.checkPageComplete();
    }

    protected void populateData() {
        TRCAgentProxy tRCAgentProxy;
        IResource iResource = HyadesUtil.getSelectionFolder((INavigator)this.fViewer);
        if (iResource != null) {
            this._locationUI.setLocation(iResource.getFullPath().toOSString());
        }
        if ((tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent()) == null) {
            return;
        }
        this._locationUI.setMonitor(tRCAgentProxy.getProcessProxy().getNode().getMonitor().getName());
        if (tRCAgentProxy.isToProfileFile()) {
            this._fileUI.getExternalBox().setSelection(true);
            this._fileUI.setEnabled(true);
            this._fileUI.setFile(tRCAgentProxy.getProfileFile());
        }
        if (!tRCAgentProxy.isActive() || tRCAgentProxy.isActive() && tRCAgentProxy.isAttached()) {
            this._fileUI.setEnabled(false);
            this._fileUI.getExternalBox().setEnabled(false);
        }
    }

    private void checkPageComplete() {
        this.setPageComplete(!this._locationUI.getLocation().getText().trim().equals("") && !this._locationUI.getMonitor().getText().trim().equals("") && (!this._fileUI.getSelection() || !this._fileUI.getFile().equals("")));
    }
}

