/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentFolderPage;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class OpenProfAgentWizard
extends Wizard
implements INewWizard {
    protected TRCAgentProxy fAgent;
    protected PDProjectExplorer fViewer;
    protected OpenProfAgentPage fFilterPage;
    protected OpenProfAgentFolderPage fFolderPage;

    public void addPages() {
        this.setWindowTitle(UIPlugin.getResourceString("STR_PROPERTIES"));
        this.fFolderPage = new OpenProfAgentFolderPage("folderPage", this.fViewer);
        this.fFilterPage = new OpenProfAgentPage("agentPage", this.fViewer);
        this.addPage((IWizardPage)this.fFolderPage);
        this.addPage((IWizardPage)this.fFilterPage);
    }

    public TRCAgentProxy getAgent() {
        return this.fAgent;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        Object e;
        Iterator iterator;
        if (iStructuredSelection instanceof IStructuredSelection && (iterator = iStructuredSelection.iterator()).hasNext() && (e = iterator.next()) instanceof TRCAgentProxy) {
            this.fAgent = (TRCAgentProxy)e;
        }
        this.setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor("agent_prop_wiz.gif"));
    }

    public boolean performFinish() {
        if (!(this.fFolderPage.getFile().equals("") || PDCoreUtil.isPathExists(this.fFolderPage.getFile()) || PDCoreUtil.createDirectoryMessage(this.fFolderPage.getFile(), this.getShell()))) {
            return false;
        }
        boolean bl = true;
        bl = this.fFilterPage.finish() && this.fFolderPage.finish();
        return true;
    }

    public void setViewer(PDProjectExplorer pDProjectExplorer) {
        this.fViewer = pDProjectExplorer;
    }

    public boolean isProfilingAgent() {
        if (this.fAgent != null) {
            return this.fAgent.getType().equals("Profiler") && !this.fAgent.getName().equals("J2EE Request Profiler");
        }
        return true;
    }
}

