/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.io.ByteArrayInputStream;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEvaluatorExt;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DPLCellImpl
extends EObjectImpl
implements DPLCell,
IDatapoolCell {
    public static final String copyright = "";
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected DPLVariable variable = null;
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";

    protected DPLCellImpl() {
    }

    protected EClass eStaticClass() {
        return Common_DatapoolPackage.eINSTANCE.getDPLCell();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        String string2 = this.value;
        this.value = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)string2, (Object)this.value));
        }
    }

    public DPLVariable getVariable() {
        if (this.variable != null && this.variable.eIsProxy()) {
            DPLVariable dPLVariable = this.variable;
            this.variable = (DPLVariable)EcoreUtil.resolve((EObject)this.variable, (EObject)this);
            if (this.variable != dPLVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)dPLVariable, (Object)this.variable));
            }
        }
        return this.variable;
    }

    public DPLVariable basicGetVariable() {
        return this.variable;
    }

    public void setVariable(DPLVariable dPLVariable) {
        DPLVariable dPLVariable2 = this.variable;
        this.variable = dPLVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)dPLVariable2, (Object)this.variable));
        }
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getValue();
            }
            case 1: {
                if (bl) {
                    return this.getVariable();
                }
                return this.basicGetVariable();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setValue((String)object);
                return;
            }
            case 1: {
                this.setVariable((DPLVariable)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setVariable((DPLVariable)null);
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 1: {
                return this.variable != null;
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (value: ");
        stringBuffer.append(this.value);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void setVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable iDatapoolVariable) {
        this.setVariable((DPLVariable)iDatapoolVariable);
    }

    public String getPersistedRepresentation() {
        return this.getValue();
    }

    public IDatapoolVariable getCellVariable() {
        return (IDatapoolVariable)this.getVariable();
    }

    public IDatapoolRecord getCellRecord() {
        return (IDatapoolRecord)this.eContainer();
    }

    public Object getCellValue() {
        if (this.getValue() == null) {
            return null;
        }
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.models.common.datapool_evaluator");
        if (iExtensionPoint != null) {
            DPLLogImpl.log("ext point found!!!");
            try {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                DPLLogImpl.log("extensions.length: " + iExtensionArray.length);
                String string = null;
                String string2 = null;
                if (iExtensionArray.length > 0) {
                    IConfigurationElement[] iConfigurationElementArray;
                    ByteArrayInputStream byteArrayInputStream;
                    try {
                        DOMParser dOMParser = new DOMParser();
                        byteArrayInputStream = new ByteArrayInputStream(this.getValue().getBytes());
                        iConfigurationElementArray = new InputSource(byteArrayInputStream);
                        dOMParser.parse((InputSource)iConfigurationElementArray);
                        Document document = dOMParser.getDocument();
                        string = document.getFirstChild().getFirstChild().getNodeName();
                        DPLLogImpl.log("Tag: " + string);
                        string2 = document.getFirstChild().getFirstChild().getFirstChild().getNodeValue();
                        DPLLogImpl.log("Val: " + string2);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        throw new DatapoolException("Error while evaluating datapool cell value: " + this.getValue());
                    }
                    int n = 0;
                    while (n < iExtensionArray.length) {
                        byteArrayInputStream = iExtensionArray[n];
                        DPLLogImpl.log("   extension:" + byteArrayInputStream.getUniqueIdentifier());
                        iConfigurationElementArray = byteArrayInputStream.getConfigurationElements();
                        DPLLogImpl.log("configElements.length : " + iConfigurationElementArray.length);
                        int n2 = 0;
                        while (n2 < iConfigurationElementArray.length) {
                            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                            String string3 = iConfigurationElement.getAttribute("tag");
                            DPLLogImpl.log("Tag: " + string3);
                            DPLLogImpl.log("configElement: " + iConfigurationElement.toString());
                            if (string.equals(string3)) {
                                IDatapoolEvaluatorExt iDatapoolEvaluatorExt = (IDatapoolEvaluatorExt)iConfigurationElement.createExecutableExtension("class");
                                DPLLogImpl.log("evaluator: " + iDatapoolEvaluatorExt.toString());
                                return iDatapoolEvaluatorExt.evaluate(string2);
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    return this.getValue();
                }
                return this.getValue();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new DatapoolException("Error while using extension point to evaluate datapool cell value: " + this.getValue());
            }
        }
        String string = this.getValue();
        String string4 = this.unwrapLiteral(string);
        return string4;
    }

    public String getStringValue() {
        Object object = this.getCellValue();
        if (object != null) {
            return object.toString();
        }
        return new String();
    }

    public long getLongValue() {
        return Long.parseLong((String)this.getCellValue());
    }

    public int getIntValue() {
        return Integer.parseInt((String)this.getCellValue());
    }

    public short getShortValue() {
        return Short.parseShort((String)this.getCellValue());
    }

    public byte getByteValue() {
        return Byte.parseByte((String)this.getCellValue());
    }

    public double getDoubleValue() {
        return Double.parseDouble((String)this.getCellValue());
    }

    public float getFloatValue() {
        return Float.parseFloat((String)this.getCellValue());
    }

    public boolean getBooleanValue() {
        return Boolean.getBoolean((String)this.getCellValue());
    }

    public char getCharValue() {
        return ((String)this.getCellValue()).charAt(0);
    }

    public void setPersistedRepresentation(String string) {
        this.setValue(string);
    }

    public void setCellValue(Object object) {
        String string = this.wrapAsLiterl(object.toString());
        this.setValue(string);
    }

    private String wrapAsLiterl(String string) {
        if (string != null) {
            return START_LITERAL + string + END_LITERAL;
        }
        return "<Literal></Literal>";
    }

    private String unwrapLiteral(String string) {
        if ((string = string.trim()).startsWith(START_LITERAL) && string.endsWith(END_LITERAL)) {
            string = string.substring(START_LITERAL.length(), string.length());
            int n = string.lastIndexOf(END_LITERAL);
            string = string.substring(0, n);
            return string;
        }
        return new String();
    }
}

