/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.Stop;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;

public class Lifeline
extends GraphNode {
    protected List executionOccurrences = new ArrayList();
    protected int indexInFrame = 0;
    private Frame frame = null;
    protected Stop stop = null;
    protected int eventOccurrence = 0;
    private int execOccurrenceDrawIndex = 0;
    protected int category = -1;

    public int getX() {
        return 33 + (this.indexInFrame - 1) * Metrics.swimmingLaneWidth();
    }

    public int getY() {
        return 26 + Metrics.getLifelineFontHeigth() + 10;
    }

    public int getWidth() {
        return Metrics.getLifelineWidth();
    }

    public int getHeight() {
        return Metrics.getLifelineFontHeigth() + 28;
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public String getToolTipText() {
        if (this.category >= 0) {
            LifelineCategories[] lifelineCategoriesArray = this.frame.getLifelineCategories();
            if (this.category < lifelineCategoriesArray.length) {
                return lifelineCategoriesArray[this.category].getName() + " " + this.getName();
            }
            return "";
        }
        return "";
    }

    protected int getExecOccurrenceDrawIndex() {
        return this.execOccurrenceDrawIndex;
    }

    public void setStop(Stop stop) {
        if (stop == null) {
            return;
        }
        this.stop = stop;
        this.stop.setLifeline(this);
    }

    public Stop getStop() {
        return this.stop;
    }

    protected void setFrame(Frame frame) {
        this.frame = frame;
        if (this.frame.getMaxEventOccurrence() < this.getEventOccurrence() + 1) {
            this.frame.setMaxEventOccurrence(this.getEventOccurrence() + 1);
        }
    }

    protected Frame getFrame() {
        return this.frame;
    }

    protected void setIndex(int n) {
        this.indexInFrame = n;
    }

    protected int getIndex() {
        return this.indexInFrame;
    }

    public void setCurrentEventOccurrence(int n) {
        if (this.frame != null && this.frame.getMaxEventOccurrence() < n) {
            this.frame.setMaxEventOccurrence(n);
        }
        this.eventOccurrence = n;
    }

    public int getEventOccurrence() {
        return this.eventOccurrence;
    }

    public int getNewEventOccurrence() {
        this.setCurrentEventOccurrence(this.eventOccurrence + 1);
        return this.eventOccurrence;
    }

    public void addExecution(ExecutionOccurrence executionOccurrence) {
        executionOccurrence.setLifeline(this);
        this.executionOccurrences.add(executionOccurrence);
        if (this.frame != null && this.frame.getMaxEventOccurrence() < executionOccurrence.endOccurrence) {
            this.frame.setMaxEventOccurrence(executionOccurrence.endOccurrence);
        }
    }

    public List getExecutions() {
        return this.executionOccurrences;
    }

    protected void updateIndex(int n, int n2) {
        int n3 = 1;
        if (n2 == 0) {
            this.execOccurrenceDrawIndex = 0;
        }
        if (this.execOccurrenceDrawIndex < this.executionOccurrences.size() && this.execOccurrenceDrawIndex >= 0 && ((ExecutionOccurrence)this.executionOccurrences.get(this.execOccurrenceDrawIndex)).getY() > n2) {
            n3 = -1;
        }
        int n4 = this.execOccurrenceDrawIndex;
        while (n4 < this.executionOccurrences.size() && n4 >= 0) {
            this.execOccurrenceDrawIndex = n4;
            if (n3 == 1 && (((ExecutionOccurrence)this.executionOccurrences.get(n4)).getY() > n2 || ((ExecutionOccurrence)this.executionOccurrences.get(n4)).getY() + ((ExecutionOccurrence)this.executionOccurrences.get(n4)).getHeight() > n2) || n3 == -1 && (((ExecutionOccurrence)this.executionOccurrences.get(n4)).getY() < n2 || ((ExecutionOccurrence)this.executionOccurrences.get(n4)).getY() + ((ExecutionOccurrence)this.executionOccurrences.get(n4)).getHeight() < n2)) break;
            n4 += n3;
        }
    }

    public boolean contains(int n, int n2) {
        int n3 = this.getX();
        int n4 = this.getY();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (this.frame == null) {
            return false;
        }
        if (Frame.contains(n3, n4, n5, n6, n, n2)) {
            return true;
        }
        return Frame.contains(n3 + Metrics.getLifelineWidth() / 2 - 5, n4 + n6, 10, (Metrics.getMessageFontHeigth() + 30) * this.frame.getMaxEventOccurrence() + 20 - 4, n, n2);
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        int n5 = this.getX();
        int n6 = this.getWidth();
        return n5 >= n && n5 <= n + n3 || n5 + n6 >= n && n5 <= n;
    }

    public void draw(IGC iGC) {
        IImage iImage;
        LifelineCategories[] lifelineCategoriesArray;
        if (this.isSelected()) {
            if (Frame.getUserPref().useGradienColor()) {
                iGC.setGradientColor(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE"));
            }
            iGC.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            iGC.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            if (Frame.getUserPref().useGradienColor()) {
                iGC.setGradientColor(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE"));
                iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
            } else {
                iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_LIFELINE"));
            }
            iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_LIFELINE"));
        }
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (Frame.getUserPref().useGradienColor()) {
            iGC.fillGradientRectangle(n, n2, n3, n4 / 2 + 1, true);
            iGC.fillGradientRectangle(n, n2 + n4, n3, -n4 / 2, true);
        } else {
            iGC.fillRectangle(n, n2, n3, n4);
        }
        iGC.drawRectangle(n, n2, n3, n4);
        if (this.category >= 0 && this.category < (lifelineCategoriesArray = this.frame.getLifelineCategories()).length && (iImage = lifelineCategoriesArray[this.category].getImage()) != null) {
            iGC.drawImage(iImage, n, n2, n3, n4);
        }
        iGC.drawTextTruncatedCentred(this.getName(), n + 20, n2, Metrics.getLifelineWidth() - 40, n4, true);
        iGC.setLineStyle(iGC.getLineDashStyle());
        int n5 = iGC.getLineStyle();
        int n6 = n2 + n4 + (Metrics.getMessageFontHeigth() + 30) * this.frame.getMaxEventOccurrence() + 20;
        if (this.stop != null) {
            n6 = this.stop.getY();
        }
        if (this.isSelected()) {
            iGC.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            iGC.setLineWidth(5);
            iGC.drawLine(n + Metrics.getLifelineWidth() / 2, n2 + n4, n + Metrics.getLifelineWidth() / 2, n6 - 4);
            iGC.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        }
        iGC.setLineWidth(1);
        iGC.drawLine(n + Metrics.getLifelineWidth() / 2, n2 + n4, n + Metrics.getLifelineWidth() / 2, n6 - 4);
        iGC.drawLine(n + Metrics.getLifelineWidth() / 2, n2 + n4, n + Metrics.getLifelineWidth() / 2, n6 - 4);
        iGC.setLineStyle(n5);
        iGC.setLineStyle(iGC.getLineSolidStyle());
        int n7 = 0;
        int n8 = this.execOccurrenceDrawIndex;
        while (n8 < this.executionOccurrences.size()) {
            ExecutionOccurrence executionOccurrence = (ExecutionOccurrence)this.executionOccurrences.get(n8);
            if (executionOccurrence.getY() > iGC.getContentsY() + iGC.getVisibleHeight()) break;
            executionOccurrence.draw(iGC);
            ++n7;
            ++n8;
        }
        if (this.stop == null) {
            return;
        }
        if (this.stop.getY() <= iGC.getContentsY() + iGC.getVisibleHeight()) {
            this.stop.draw(iGC);
        }
    }

    public void highlightExecOccurrenceRegion(IGC iGC, int n, int n2, IColor iColor) {
        IColor iColor2 = iGC.getBackground();
        iGC.setBackground(iColor);
        int n3 = this.getX() + Metrics.getLifelineWidth() / 2 - 5;
        int n4 = this.getY() + this.getHeight() + (Metrics.getMessageFontHeigth() + 30) * n;
        int n5 = 10;
        int n6 = (Metrics.getMessageFontHeigth() + 30) * n2;
        iGC.fillRectangle(n3, n4, n5, n6);
        iGC.setBackground(iColor2);
    }
}

