/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IMsgCatalogToken;
import org.eclipse.hyades.logging.events.IMsgDataElement;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.events.MsgCatalogTokenImpl;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;

public class CommonBaseEventLogRecord
extends LogRecord
implements IExternalizableToXml {
    private ICommonBaseEvent commonBaseEvent = null;
    private int logRecordMask = 0;
    private static ISimpleEventFactory simpleEventFactory = SimpleEventFactoryImpl.getInstance();
    private static final int LEVEL_ALL = Level.ALL.intValue();
    private static final int LEVEL_FINEST = Level.FINEST.intValue();
    private static final int LEVEL_FINER = Level.FINER.intValue();
    private static final int LEVEL_FINE = Level.FINE.intValue();
    private static final int LEVEL_CONFIG = Level.CONFIG.intValue();
    private static final int LEVEL_INFO = Level.INFO.intValue();
    private static final int LEVEL_WARNING = Level.WARNING.intValue();
    private static final int LEVEL_SEVERE = Level.SEVERE.intValue();
    private static final int LEVEL_OFF = Level.OFF.intValue();
    private static String localHostIP = null;

    public CommonBaseEventLogRecord(Level level, String string) {
        super(level, string);
        this.logRecordMask |= 0xF1A;
    }

    public CommonBaseEventLogRecord(Level level) {
        super(level, null);
        this.logRecordMask |= 0xF12;
    }

    public CommonBaseEventLogRecord(ICommonBaseEvent iCommonBaseEvent) {
        super(Level.OFF, null);
        this.setCommonBaseEvent(iCommonBaseEvent);
    }

    public CommonBaseEventLogRecord(LogRecord logRecord) {
        this(logRecord.getLevel(), logRecord.getMessage());
        this.setMillis(logRecord.getMillis());
        this.setSequenceNumber(logRecord.getSequenceNumber());
        this.setThreadID(logRecord.getThreadID());
        this.setLoggerName(logRecord.getLoggerName());
        this.setParameters(logRecord.getParameters());
        this.setResourceBundle(logRecord.getResourceBundle());
        this.setResourceBundleName(logRecord.getResourceBundleName());
        this.setSourceClassName(logRecord.getSourceClassName());
        this.setSourceMethodName(logRecord.getSourceMethodName());
        this.setThrown(logRecord.getThrown());
    }

    public final void setCommonBaseEvent(ICommonBaseEvent iCommonBaseEvent) {
        this.commonBaseEvent = iCommonBaseEvent;
    }

    public final ICommonBaseEvent getCommonBaseEvent() {
        if ((this.logRecordMask | 0) != 0) {
            Object object;
            CharSequence charSequence;
            Object object2;
            IExtendedDataElement iExtendedDataElement;
            Object object3;
            if (this.commonBaseEvent == null) {
                this.commonBaseEvent = simpleEventFactory.createCommonBaseEvent();
            }
            if ((this.logRecordMask & 0x200) == 512 || (this.logRecordMask & 0x400) == 1024 || (this.logRecordMask & 0x800) == 2048) {
                object3 = this.commonBaseEvent.getSourceComponentId();
                if (object3 == null) {
                    object3 = simpleEventFactory.createComponentIdentification();
                    object3.setLocation(localHostIP);
                    object3.setLocationType("IPV4");
                    object3.setExecutionEnvironment("Java");
                    object3.setComponentIdType("Application");
                    object3.setComponent("JavaApplication");
                }
                if ((this.logRecordMask & 0x200) == 512) {
                    object3.setComponent(super.getSourceClassName());
                }
                if ((this.logRecordMask & 0x400) == 1024) {
                    object3.setSubComponent(super.getSourceMethodName());
                }
                if ((this.logRecordMask & 0x800) == 2048) {
                    object3.setThreadId(String.valueOf(super.getThreadID()));
                }
                this.commonBaseEvent.setSourceComponentId((IComponentIdentification)object3);
            }
            if ((this.logRecordMask & 4) == 4) {
                object3 = this.commonBaseEvent.getReporterComponentId();
                if (object3 == null) {
                    object3 = simpleEventFactory.createComponentIdentification();
                    object3.setLocation(localHostIP);
                    object3.setLocationType("IPV4");
                    object3.setExecutionEnvironment("Java");
                    object3.setComponent("java.util.logging");
                    object3.setSubComponent("java.util.logging.Logger");
                    object3.setComponentIdType("Application");
                    object3.setComponent("JavaLogging");
                }
                object3.setInstanceId(super.getLoggerName());
                this.commonBaseEvent.setReporterComponentId((IComponentIdentification)object3);
            }
            if ((this.logRecordMask & 0x20) == 32 || (this.logRecordMask & 0x40) == 64 || (this.logRecordMask & 0x80) == 128) {
                object3 = simpleEventFactory.createMsgDataElement();
                if ((this.logRecordMask & 0x80) == 128) {
                    object3.setMsgCatalog(super.getResourceBundleName());
                }
                if ((this.logRecordMask & 0x40) == 64 && (iExtendedDataElement = super.getResourceBundle()) != null && (object2 = iExtendedDataElement.getLocale()) != null) {
                    charSequence = object2.getLanguage();
                    object = object2.getCountry();
                    if (((String)charSequence).length() > 0 && ((String)object).length() > 0) {
                        object3.setMsgLocale(((String)charSequence).concat("-").concat((String)object));
                    }
                }
                if ((this.logRecordMask & 0x20) == 32 && (iExtendedDataElement = super.getParameters()) != null && ((IExtendedDataElement)iExtendedDataElement).length > 0) {
                    object2 = new MsgCatalogTokenImpl[((IExtendedDataElement)iExtendedDataElement).length];
                    charSequence = null;
                    int n = 0;
                    while (n < ((IExtendedDataElement)iExtendedDataElement).length) {
                        charSequence = simpleEventFactory.createMsgCatalogToken();
                        charSequence.setValue(String.valueOf(iExtendedDataElement[n]));
                        object2[n] = charSequence;
                        ++n;
                    }
                    object3.setMsgCatalogTokens((IMsgCatalogToken[])object2);
                }
                this.commonBaseEvent.setMsgDataElement((IMsgDataElement)object3);
            }
            if ((this.logRecordMask & 0x1000) == 4096 && (object3 = super.getThrown()) != null) {
                iExtendedDataElement = simpleEventFactory.createExtendedDataElement();
                iExtendedDataElement.setName("parm1");
                iExtendedDataElement.setType(6);
                object2 = ((Throwable)object3).getMessage();
                charSequence = new StringBuffer(object3.getClass().getName());
                if (object2 != null) {
                    ((StringBuffer)charSequence).append(':');
                    ((StringBuffer)charSequence).append((String)object2);
                }
                if ((object = ((Throwable)object3).getCause()) != null) {
                    ((StringBuffer)charSequence).append(":Cause:");
                    ((StringBuffer)charSequence).append(object.getClass().getName());
                    object2 = ((Throwable)object).getMessage();
                    if (object2 != null) {
                        ((StringBuffer)charSequence).append(':');
                        ((StringBuffer)charSequence).append((String)object2);
                    }
                }
                iExtendedDataElement.setValues(new String[]{((StringBuffer)charSequence).toString()});
                this.commonBaseEvent.addExtendedDataElement(iExtendedDataElement);
                StackTraceElement[] stackTraceElementArray = ((Throwable)object3).getStackTrace();
                int n = 0;
                while (n < stackTraceElementArray.length) {
                    iExtendedDataElement = simpleEventFactory.createExtendedDataElement();
                    iExtendedDataElement.setName("parm".concat(String.valueOf(n + 2)));
                    iExtendedDataElement.setType(6);
                    iExtendedDataElement.setValues(new String[]{stackTraceElementArray[n].toString()});
                    this.commonBaseEvent.addExtendedDataElement(iExtendedDataElement);
                    ++n;
                }
            }
            if ((this.logRecordMask & 0x100) == 256) {
                object3 = simpleEventFactory.createExtendedDataElement();
                object3.setName("SequenceNumber");
                object3.setType(3);
                object3.setValues(new String[]{String.valueOf(super.getSequenceNumber())});
                this.commonBaseEvent.addExtendedDataElement((IExtendedDataElement)object3);
            }
            if ((this.logRecordMask & 2) == 2) {
                this.setCBESeverity(super.getLevel());
            }
            if ((this.logRecordMask & 8) == 8 || (this.logRecordMask & 0x20) == 32 || (this.logRecordMask & 0x40) == 64) {
                this.commonBaseEvent.setMsg(this.formatMessage(super.getMessage(), super.getResourceBundle(), super.getParameters()));
            }
            if ((this.logRecordMask & 0x10) == 16) {
                this.commonBaseEvent.setCreationTime(super.getMillis());
            }
            this.logRecordMask = 0;
        }
        return this.commonBaseEvent;
    }

    public final String externalizeCanonicalXmlString() {
        return CbeFormatter.toCanonicalXMLString((ICommonBaseEvent)this.getCommonBaseEvent());
    }

    public final String externalizeCanonicalXmlDocString() {
        return CbeFormatter.toCanonicalXMLDocString((ICommonBaseEvent)this.getCommonBaseEvent());
    }

    private void setCBESeverity(Level level) {
        IExtendedDataElement iExtendedDataElement = this.commonBaseEvent.getExtendedDataElement("LoggingLevel");
        if (iExtendedDataElement == null) {
            iExtendedDataElement = simpleEventFactory.createExtendedDataElement();
            iExtendedDataElement.setType(6);
            iExtendedDataElement.setName("LoggingLevel");
        }
        IReportSituation iReportSituation = simpleEventFactory.createReportSituation();
        iReportSituation.setReasoningScope("INTERNAL");
        ISituation iSituation = this.commonBaseEvent.getSituation();
        if (iSituation == null) {
            iSituation = simpleEventFactory.createSituation();
        }
        iSituation.setCategoryName("ReportSituation");
        iSituation.setSituationType((ISituationType)iReportSituation);
        int n = level.intValue();
        if (n == LEVEL_ALL) {
            this.commonBaseEvent.setSeverity((short)0);
            iExtendedDataElement.setValues(new String[]{"ALL"});
            iReportSituation.setReportCategory("LOG");
        } else if (n == LEVEL_FINEST) {
            this.commonBaseEvent.setSeverity((short)10);
            iExtendedDataElement.setValues(new String[]{"FINIST"});
            iReportSituation.setReportCategory("TRACE");
        } else if (n == LEVEL_FINER) {
            this.commonBaseEvent.setSeverity((short)10);
            iExtendedDataElement.setValues(new String[]{"FINER"});
            iReportSituation.setReportCategory("TRACE");
        } else if (n == LEVEL_FINE) {
            this.commonBaseEvent.setSeverity((short)10);
            iExtendedDataElement.setValues(new String[]{"FINE"});
            iReportSituation.setReportCategory("TRACE");
        } else if (n == LEVEL_CONFIG) {
            this.commonBaseEvent.setSeverity((short)10);
            iExtendedDataElement.setValues(new String[]{"CONFIG"});
            iReportSituation.setReportCategory("TRACE");
        } else if (n == LEVEL_INFO) {
            this.commonBaseEvent.setSeverity((short)10);
            iExtendedDataElement.setValues(new String[]{"INFO"});
            iReportSituation.setReportCategory("LOG");
        } else if (n == LEVEL_WARNING) {
            this.commonBaseEvent.setSeverity((short)30);
            iExtendedDataElement.setValues(new String[]{"WARNING"});
            iReportSituation.setReportCategory("LOG");
        } else if (n == LEVEL_SEVERE) {
            this.commonBaseEvent.setSeverity((short)60);
            iExtendedDataElement.setValues(new String[]{"SEVERE"});
            iReportSituation.setReportCategory("LOG");
        } else if (n == LEVEL_OFF) {
            this.commonBaseEvent.setSeverity((short)70);
            iExtendedDataElement.setValues(new String[]{"OFF"});
            iReportSituation.setReportCategory("LOG");
        } else {
            this.commonBaseEvent.setSeverity((short)70);
            iExtendedDataElement.setValues(new String[]{level.getName()});
            iReportSituation.setReportCategory("LOG");
        }
    }

    private String formatMessage(String string, ResourceBundle resourceBundle, Object[] objectArray) {
        if (string != null) {
            String string2 = string;
            if (resourceBundle != null) {
                try {
                    string2 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (objectArray != null && objectArray.length > 0 && string2.indexOf("{0") != -1) {
                string2 = MessageFormat.format(string2, objectArray);
            }
            return string2;
        }
        return null;
    }

    public final void setLevel(Level level) {
        super.setLevel(level);
        this.logRecordMask |= 2;
    }

    public final void setLoggerName(String string) {
        super.setLoggerName(string);
        this.logRecordMask |= 4;
    }

    public final void setMessage(String string) {
        super.setMessage(string);
        this.logRecordMask |= 8;
    }

    public final void setMillis(long l) {
        super.setMillis(l);
        this.logRecordMask |= 0x10;
    }

    public final void setParameters(Object[] objectArray) {
        super.setParameters(objectArray);
        this.logRecordMask |= 0x20;
    }

    public final void setResourceBundle(ResourceBundle resourceBundle) {
        super.setResourceBundle(resourceBundle);
        this.logRecordMask |= 0x40;
    }

    public final void setResourceBundleName(String string) {
        super.setResourceBundleName(string);
        this.logRecordMask |= 0x80;
    }

    public final void setSequenceNumber(long l) {
        super.setSequenceNumber(l);
        this.logRecordMask |= 0x100;
    }

    public final void setSourceClassName(String string) {
        super.setSourceClassName(string);
        this.logRecordMask |= 0x200;
    }

    public final void setSourceMethodName(String string) {
        super.setSourceMethodName(string);
        this.logRecordMask |= 0x400;
    }

    public final void setThreadID(int n) {
        super.setThreadID(n);
        this.logRecordMask |= 0x800;
    }

    public final void setThrown(Throwable throwable) {
        super.setThrown(throwable);
        this.logRecordMask |= 0x1000;
    }

    public String toString() {
        return this.getCommonBaseEvent().toString();
    }

    static {
        try {
            localHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            localHostIP = "127.0.0.1";
        }
    }
}

