/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;

public class StandaloneSystemUtility
implements ISystemUtility {
    private ResourceBundle bundle;
    private String harnessDir;
    private String localizedBundleJar;

    public StandaloneSystemUtility(String string) {
        this.harnessDir = string;
        if (string.charAt(string.length() - 1) == '/') {
            this.localizedBundleJar = string.substring(0, string.length() - 2);
        } else {
            this.harnessDir = this.harnessDir + '/';
            this.localizedBundleJar = string;
        }
        this.localizedBundleJar = this.localizedBundleJar + ".nl1/nl1.jar";
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(Locale.getDefault());
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (this.bundle != null) {
            return this.bundle;
        }
        ResourceBundle resourceBundle = null;
        try {
            URL[] uRLArray = new URL[]{new URL("file", "", this.harnessDir), new URL("file", "", this.localizedBundleJar)};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, null);
            this.bundle = resourceBundle = ResourceBundle.getBundle("plugin", locale, uRLClassLoader);
        }
        catch (MalformedURLException malformedURLException) {
            this.logError(malformedURLException);
            return null;
        }
        catch (MissingResourceException missingResourceException) {
            this.logError(missingResourceException);
            return null;
        }
        return resourceBundle;
    }

    public String getString(String string) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (resourceBundle == null) {
            return string;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public void logError(Throwable throwable) {
        System.out.println(throwable.getMessage());
    }
}

