/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;

public class ExecutionEnvironmentImpl
extends ExecutionComponentImpl
implements IExecutionEnvironment {
    protected static ArrayList originalProcessEnvironment = new ArrayList();
    protected ArrayList processEnvironment = new ArrayList();
    private static boolean nativesAvailable;

    public void init() {
        int n;
        if (originalProcessEnvironment.size() == 0) {
            IOrderedProperty[] iOrderedPropertyArray = this.getNativeSystemEnvironment();
            n = 0;
            while (n < iOrderedPropertyArray.length) {
                try {
                    if (iOrderedPropertyArray[n] == null) break;
                    originalProcessEnvironment.add((IOrderedProperty)((OrderedPropertyImpl)iOrderedPropertyArray[n]).clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                ++n;
            }
        }
        n = 0;
        while (n < originalProcessEnvironment.size()) {
            try {
                this.processEnvironment.add((IOrderedProperty)((OrderedPropertyImpl)originalProcessEnvironment.get(n)).clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderedProperty[] getEnv() throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            IOrderedProperty[] iOrderedPropertyArray = new IOrderedProperty[this.processEnvironment.size()];
            int n = 0;
            while (n < iOrderedPropertyArray.length) {
                try {
                    iOrderedPropertyArray[n] = (IOrderedProperty)((OrderedPropertyImpl)this.processEnvironment.get(n)).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                ++n;
            }
            return iOrderedPropertyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderedProperty getEnvByName(String string) throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            Iterator iterator = this.processEnvironment.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                IOrderedProperty iOrderedProperty = (IOrderedProperty)iterator.next();
                if (iOrderedProperty.getName().equalsIgnoreCase(string)) {
                    return iOrderedProperty;
                }
                ++n;
            }
        }
        return null;
    }

    public void setEnv(IOrderedProperty[] iOrderedPropertyArray) throws ExecutionComponentStateException {
        this.processEnvironment.clear();
        int n = 0;
        while (n < iOrderedPropertyArray.length) {
            this.processEnvironment.add(iOrderedPropertyArray[n]);
            ++n;
        }
    }

    public void addEnv(IOrderedProperty iOrderedProperty) throws ExecutionComponentStateException {
        this.processEnvironment.add(iOrderedProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderedProperty removeProperty(String string) throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            Iterator iterator = this.processEnvironment.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                IOrderedProperty iOrderedProperty = (IOrderedProperty)iterator.next();
                if (iOrderedProperty.getName().equalsIgnoreCase(string)) {
                    this.processEnvironment.remove(n);
                    return iOrderedProperty;
                }
                ++n;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnv(IOrderedProperty iOrderedProperty) throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            Iterator iterator = this.processEnvironment.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                IOrderedProperty iOrderedProperty2 = (IOrderedProperty)iterator.next();
                if (iOrderedProperty2.getName().equalsIgnoreCase(iOrderedProperty.getName())) {
                    this.processEnvironment.remove(n);
                    this.processEnvironment.add(n, iOrderedProperty);
                    return;
                }
                ++n;
            }
        }
        this.addEnv(iOrderedProperty);
    }

    private IOrderedProperty[] getNativeSystemEnvironment() {
        if (nativesAvailable) {
            return (IOrderedProperty[])this.getNativeSystemEnvironment0();
        }
        return new IOrderedProperty[0];
    }

    private native Object[] getNativeSystemEnvironment0();

    static {
        try {
            System.loadLibrary("hclaunch");
            nativesAvailable = true;
        }
        catch (Throwable throwable) {
            nativesAvailable = false;
        }
    }
}

