/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.preferences;

import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class HttpRecorderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button autoStartAppBtn;
    private Combo recordedAppAdapterCombo;
    private Combo testGeneratorsCombo;
    private Text proxyPort;
    private Button autoStartTestGenBtn;

    public HttpRecorderPreferencePage() {
        this.setPreferenceStore(HttpRecorderPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = null;
        try {
            this.setTitle(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.HTTP_PROXY_RECORD_OPTIONS_TITLE"));
            composite2 = new Composite(composite, 0);
            WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.hyades.execution.recorder.http.HttpRecorderPreferencePage");
            composite2.setLayoutData((Object)new GridData(768));
            RecorderUIUtility.assignGridLayout((Composite)composite2, (int)2, (boolean)false);
            this.createApplicationOptionsGroup(composite2);
            this.createTestGenOptionsGroup(composite2);
            this.createRecorderProxyGroup(composite2);
        }
        catch (RecorderUIUtility.RecorderHarnessUIException recorderHarnessUIException) {
            recorderHarnessUIException.printStackTrace();
        }
        this.setControl((Control)composite);
        return composite;
    }

    private void createRecorderProxyGroup(Composite composite) throws RecorderUIUtility.RecorderHarnessUIException {
        Label label = RecorderUIUtility.createLabel((Composite)composite, (String)HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.PROXY_RECORDER_LOCAL_PORT_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)label, (int)1, (int)128);
        this.proxyPort = RecorderUIUtility.createEditControl((Composite)composite, (String)HttpRecorderPlugin.getPreference("default_proxy_port"), null);
        RecorderUIUtility.layoutControlInGrid((Control)this.proxyPort, (int)1, (int)768);
        this.proxyPort.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == HttpRecorderPreferencePage.this.proxyPort) {
                    int n;
                    try {
                        n = Integer.parseInt(HttpRecorderPreferencePage.this.proxyPort.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        HttpRecorderPreferencePage.this.setErrorMessage(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.PORT_NOT_A_NUMBER"));
                        HttpRecorderPreferencePage.this.setValid(false);
                        return;
                    }
                    if (n <= 0) {
                        HttpRecorderPreferencePage.this.setErrorMessage(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.PORT_TOO_SMALL"));
                        HttpRecorderPreferencePage.this.setValid(false);
                        return;
                    }
                    if (n > 64000) {
                        HttpRecorderPreferencePage.this.setErrorMessage(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.PORT_TOO_BIG"));
                        HttpRecorderPreferencePage.this.setValid(false);
                        return;
                    }
                    HttpRecorderPreferencePage.this.setErrorMessage(null);
                    HttpRecorderPreferencePage.this.setValid(true);
                }
            }
        });
    }

    private void createApplicationOptionsGroup(Composite composite) throws RecorderUIUtility.RecorderHarnessUIException {
        Label label = RecorderUIUtility.createLabel((Composite)composite, (String)HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.APPLICATION_ADAPTER_SELECTOR_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)label, (int)1, (int)128);
        this.recordedAppAdapterCombo = new Combo(composite, 12);
        RecorderAppAdapterFactory recorderAppAdapterFactory = RecorderAppAdapterFactory.getInstance();
        String[] stringArray = recorderAppAdapterFactory.getAdapterIDs();
        int n = 0;
        while (n < stringArray.length) {
            this.recordedAppAdapterCombo.add(recorderAppAdapterFactory.getAdapterName(stringArray[n]));
            ++n;
        }
        this.recordedAppAdapterCombo.add(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"));
        this.selectApplication(HttpRecorderPlugin.getPreference("application_under_test"));
        RecorderUIUtility.layoutControlInGrid((Control)this.recordedAppAdapterCombo, (int)1, (int)768);
        RecorderUIUtility.layoutControlInGrid((Control)this.recordedAppAdapterCombo, (int)1, (int)768);
    }

    private void createTestGenOptionsGroup(Composite composite) throws RecorderUIUtility.RecorderHarnessUIException {
        Label label = RecorderUIUtility.createLabel((Composite)composite, (String)HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.TEST_GENERATOR_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)label, (int)1, (int)128);
        this.testGeneratorsCombo = new Combo(composite, 12);
        TestGeneratorFactory testGeneratorFactory = TestGeneratorFactory.getInstance();
        int n = 0;
        while (n < testGeneratorFactory.getGeneratorIDs().length) {
            String string = testGeneratorFactory.getGeneratorName(testGeneratorFactory.getGeneratorIDs()[n]);
            this.testGeneratorsCombo.add(string);
            ++n;
        }
        this.testGeneratorsCombo.add(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"));
        this.selectGenerator(TestgenPlugin.getPreference((String)"default_test_generator"));
        RecorderUIUtility.layoutControlInGrid((Control)this.testGeneratorsCombo, (int)1, (int)768);
        RecorderUIUtility.layoutControlInGrid((Control)this.testGeneratorsCombo, (int)1, (int)768);
    }

    public void updateControls() {
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = HttpRecorderPlugin.getDefault().getPreferenceStore();
        this.selectApplication(iPreferenceStore.getDefaultString("application_under_test"));
        this.selectGenerator(TestgenPlugin.getDefault().getPreferenceStore().getDefaultString("default_test_generator"));
        this.proxyPort.setText(iPreferenceStore.getDefaultString("default_proxy_port"));
        super.performDefaults();
    }

    protected void performApply() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        IPreferenceStore iPreferenceStore2 = TestgenPlugin.getDefault().getPreferenceStore();
        String string = RecorderAppAdapterFactory.getInstance().getAdapterIDByIndex(this.recordedAppAdapterCombo.getSelectionIndex());
        if (string != null) {
            iPreferenceStore.setValue("application_under_test", string);
        } else {
            iPreferenceStore.setValue("application_under_test", "-1");
        }
        String string2 = TestGeneratorFactory.getInstance().getGeneratorIDByIndex(this.testGeneratorsCombo.getSelectionIndex());
        if (string2 != null) {
            iPreferenceStore2.setValue("default_test_generator", string2);
        } else {
            iPreferenceStore2.setValue("default_test_generator", "-1");
        }
        iPreferenceStore.setValue("default_proxy_port", this.proxyPort.getText());
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    private void selectApplication(String string) {
        RecorderAppAdapterFactory recorderAppAdapterFactory = RecorderAppAdapterFactory.getInstance();
        String[] stringArray = recorderAppAdapterFactory.getAdapterIDs();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = recorderAppAdapterFactory.getAdapterName(stringArray[n]);
            if (stringArray[n].compareToIgnoreCase(string) == 0) {
                this.recordedAppAdapterCombo.select(n);
                return;
            }
            ++n;
        }
        this.recordedAppAdapterCombo.select(this.recordedAppAdapterCombo.indexOf(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT")));
    }

    private void selectGenerator(String string) {
        TestGeneratorFactory testGeneratorFactory = TestGeneratorFactory.getInstance();
        int n = 0;
        while (n < testGeneratorFactory.getGeneratorIDs().length) {
            String string2 = testGeneratorFactory.getGeneratorName(testGeneratorFactory.getGeneratorIDs()[n]);
            if (testGeneratorFactory.getGeneratorIDs()[n].compareToIgnoreCase(string) == 0) {
                this.testGeneratorsCombo.select(n);
                return;
            }
            ++n;
        }
        this.testGeneratorsCombo.select(this.testGeneratorsCombo.indexOf(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT")));
    }

    class SelectionChangeHandler
    implements SelectionListener {
        SelectionChangeHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HttpRecorderPreferencePage.this.updateControls();
        }
    }
}

