/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.ui.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.probekit.Compiler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ProbekitUICompileAction
implements IObjectActionDelegate {
    List selectedFileList;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        Shell shell = new Shell();
        try {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ProbekitUICompileAction.this.runWithProgress(iProgressMonitor);
                    }
                    catch (Throwable throwable) {
                        throw new InvocationTargetException(throwable);
                    }
                }
            };
            new ProgressMonitorDialog(shell).run(true, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openInformation((Shell)shell, (String)"Probekit Compiler", (String)("Exception while processing probes: " + invocationTargetException.getTargetException().getMessage()));
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)shell, (String)"Probekit Compiler", (String)"Interrupted while processing probes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithProgress(IProgressMonitor iProgressMonitor) throws Throwable {
        iProgressMonitor.beginTask("Compiling probe(s)...", 3);
        try {
            Object object;
            if (this.selectedFileList == null || this.selectedFileList.size() == 0) {
                throw new Throwable("No probe files are selected");
            }
            IFile iFile = (IFile)this.selectedFileList.get(0);
            String string = this.getBaseName(iFile.getName());
            Compiler compiler = new Compiler();
            compiler.setClassPrefix(string);
            Iterator iterator = this.selectedFileList.iterator();
            while (iterator.hasNext()) {
                object = (IFile)iterator.next();
                compiler.addFile(object.getLocation().toOSString());
            }
            iProgressMonitor.subTask("Generating Java source...");
            iProgressMonitor.worked(1);
            object = compiler.getGeneratedSource();
            iProgressMonitor.subTask("Saving Java source...");
            iProgressMonitor.worked(1);
            IFile iFile2 = iFile.getParent().getFile((IPath)new Path(string + "_probe.java"));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
            if (iFile2.exists()) {
                iFile2.setContents((InputStream)byteArrayInputStream, true, false, iProgressMonitor);
            } else {
                iFile2.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
            }
            iProgressMonitor.subTask("Saving BCI engine script...");
            iProgressMonitor.worked(1);
            String string2 = compiler.getEngineScript();
            IFile iFile3 = iFile.getParent().getFile((IPath)new Path(string + ".probescript"));
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(string2.getBytes());
            if (iFile3.exists()) {
                iFile3.setContents((InputStream)byteArrayInputStream2, true, false, iProgressMonitor);
            } else {
                iFile3.create((InputStream)byteArrayInputStream2, true, iProgressMonitor);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    private String getBaseName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        iAction.setEnabled(true);
        iAction.setChecked(false);
        this.selectedFileList = new LinkedList();
        if (iSelection != null && iSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                IFile iFile;
                Object e = iterator.next();
                if (!(e instanceof IFile) || !(iFile = (IFile)e).getName().endsWith(".probe")) continue;
                this.selectedFileList.add(iFile);
            }
        }
    }
}

