/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.probekit.DataType;
import org.eclipse.hyades.models.probekit.DataType1;
import org.eclipse.hyades.models.probekit.DocumentRoot;
import org.eclipse.hyades.models.probekit.FragmentType;
import org.eclipse.hyades.models.probekit.FragmentType1;
import org.eclipse.hyades.models.probekit.ImportType;
import org.eclipse.hyades.models.probekit.NameType;
import org.eclipse.hyades.models.probekit.ProbeType;
import org.eclipse.hyades.models.probekit.ProbekitType;
import org.eclipse.hyades.models.probekit.TargetType;

public class Compiler {
    private List probekits = new LinkedList();
    private int compilerState = 0;
    private static final int STATE_DIRTY = 0;
    private static final int STATE_CLEAN = 1;
    private StringBuffer generatedSource;
    private static final String lineSeparator = System.getProperty("line.separator");
    private String classPrefix = "";
    private static DataItemDesc[] dataItemDescs;
    static final String PROBE_INNER_CLASS_NAME_PREFIX = "Probe_";
    static final String INVOCATION_OBJECT_TYPE_SIGNATURE = "Ljava/lang/Object;";
    static final int FRAGMENT_TYPE_COUNT = 5;
    private Map probeDetailsMap;
    private Set controlKeysSet;
    private int nextSerialNumber;

    public Compiler() {
        dataItemDescs = new DataItemDesc[8];
        Compiler.dataItemDescs[0] = new DataItemDesc("returnedObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[1] = new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;");
        Compiler.dataItemDescs[2] = new DataItemDesc("className", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[3] = new DataItemDesc("methodName", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[4] = new DataItemDesc("methodSig", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[5] = new DataItemDesc("thisObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[6] = new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;");
        Compiler.dataItemDescs[7] = new DataItemDesc("isFinally", "boolean", "Z");
    }

    public Compiler(ProbekitType probekitType) {
        dataItemDescs = new DataItemDesc[8];
        Compiler.dataItemDescs[0] = new DataItemDesc("returnedObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[1] = new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;");
        Compiler.dataItemDescs[2] = new DataItemDesc("className", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[3] = new DataItemDesc("methodName", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[4] = new DataItemDesc("methodSig", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[5] = new DataItemDesc("thisObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[6] = new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;");
        Compiler.dataItemDescs[7] = new DataItemDesc("isFinally", "boolean", "Z");
        this.probekits.add(probekitType);
    }

    public Compiler(String string) throws ProbekitException {
        dataItemDescs = new DataItemDesc[8];
        Compiler.dataItemDescs[0] = new DataItemDesc("returnedObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[1] = new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;");
        Compiler.dataItemDescs[2] = new DataItemDesc("className", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[3] = new DataItemDesc("methodName", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[4] = new DataItemDesc("methodSig", "String", "Ljava/lang/String;");
        Compiler.dataItemDescs[5] = new DataItemDesc("thisObject", "Object", INVOCATION_OBJECT_TYPE_SIGNATURE);
        Compiler.dataItemDescs[6] = new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;");
        Compiler.dataItemDescs[7] = new DataItemDesc("isFinally", "boolean", "Z");
        this.addFile(string);
    }

    public void setClassPrefix(String string) {
        this.classPrefix = string;
        this.setDirtyState();
    }

    public void addProbekit(ProbekitType probekitType) {
        this.probekits.add(probekitType);
    }

    public void addFile(String string) throws ProbekitException {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createFileURI((String)string);
        Resource resource = resourceSetImpl.getResource(uRI, true);
        if (resource == null) {
            throw new ProbekitException("Failed to read resource from file " + string);
        }
        this.addResource(resource);
    }

    public void addResource(Resource resource) throws ProbekitException {
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof DocumentRoot)) {
                throw new ProbekitException("Probe compiler internal error: resource doesn't contain a DocumentRoot");
            }
            DocumentRoot documentRoot = (DocumentRoot)e;
            ProbekitType probekitType = documentRoot.getProbekit();
            if (probekitType == null) continue;
            this.probekits.add(probekitType);
        }
        this.setDirtyState();
    }

    public void verify() throws ProbekitException {
        String string = new String();
        if (!this.isValidJavaIdentifier(this.getOuterClassName())) {
            string = string + "Class prefix \"" + this.classPrefix + "\"" + "results in an invalid Java identifier " + "\"" + this.getOuterClassName() + "\"" + lineSeparator;
        }
        try {
            int n = 1;
            Iterator iterator = this.probekits.iterator();
            while (iterator.hasNext()) {
                ProbekitType probekitType = (ProbekitType)iterator.next();
                if (probekitType.getProbe() == null) {
                    throw new ProbekitException("Probe set includes a Probekit object with a null probe list");
                }
                Iterator iterator2 = probekitType.getProbe().iterator();
                while (iterator2.hasNext()) {
                    ProbeType probeType = (ProbeType)iterator2.next();
                    try {
                        if (probeType == null) {
                            throw new ProbekitException("Probe list includes a null probe reference");
                        }
                        this.verifyOneProbe(probeType);
                    }
                    catch (ProbekitException probekitException) {
                        string = string + "Probe #" + n + ": " + probekitException.getMessage() + lineSeparator;
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            throw new ProbekitException("Verification error(s): " + lineSeparator + string + lineSeparator + "Unexpected exception while verifying probe set: " + throwable);
        }
        if (string.length() != 0) {
            throw new ProbekitException("Verification error(s): " + lineSeparator + string);
        }
    }

    private void verifyOneProbe(ProbeType probeType) throws ProbekitException {
        String string;
        Object object;
        Iterator iterator;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (probeType.getImport() != null) {
            iterator = probeType.getImport().iterator();
            while (iterator.hasNext()) {
                object = (ImportType)iterator.next();
                string = object.getText();
                if (string != null && !string.equals("")) continue;
                throw new ProbekitException("An import has no text");
            }
        }
        if (probeType.getFragmentAtClassScope() != null && probeType.getFragmentAtClassScope() == null) {
            throw new ProbekitException("The fragment at class scope has a null value");
        }
        if (probeType.getFragment() == null) {
            throw new ProbekitException("The fragment list is null");
        }
        iterator = probeType.getFragment().iterator();
        while (iterator.hasNext()) {
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            FragmentType1 fragmentType1 = (FragmentType1)iterator.next();
            FragmentType fragmentType = fragmentType1.getType();
            if (fragmentType == null) {
                throw new ProbekitException("A fragment type is null");
            }
            String string2 = fragmentType.getName();
            if (string2 == null) {
                throw new ProbekitException("A fragment type string is null");
            }
            if (string2.equals("entry")) {
                bl6 = true;
                if (bl) {
                    throw new ProbekitException("only one entry fragment is allowed");
                }
                bl = true;
            } else if (string2.equals("exit")) {
                bl7 = true;
                if (bl2) {
                    throw new ProbekitException("only one exit fragment is allowed");
                }
                bl2 = true;
            } else if (string2.equals("catch")) {
                bl8 = true;
                if (bl3) {
                    throw new ProbekitException("only one catch fragment is allowed");
                }
                bl3 = true;
            } else if (string2.equals("beforeCall")) {
                bl9 = true;
                if (bl4) {
                    throw new ProbekitException("only one beforeCall fragment is allowed");
                }
                bl4 = true;
            } else if (string2.equals("afterCall")) {
                bl10 = true;
                if (bl5) {
                    throw new ProbekitException("only one afterCall fragment is allowed");
                }
                bl5 = true;
            } else {
                throw new ProbekitException("Unrecognized fragment type string " + string2);
            }
            if ((bl || bl2 || bl3) && (bl4 || bl5)) {
                throw new ProbekitException("Invalid fragment type combination: callsite and method types can not appear together");
            }
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            boolean bl14 = false;
            boolean bl15 = false;
            boolean bl16 = false;
            boolean bl17 = false;
            boolean bl18 = false;
            if (fragmentType1.getData() != null) {
                Iterator iterator2 = fragmentType1.getData().iterator();
                while (iterator2.hasNext()) {
                    DataType1 dataType1 = (DataType1)iterator2.next();
                    DataType dataType = dataType1.getType();
                    if (dataType == null) {
                        throw new ProbekitException("a data item type enum is null");
                    }
                    String string3 = dataType.getName();
                    if (string3 == null) {
                        throw new ProbekitException("a data item has null type string");
                    }
                    if (string3.equals("className")) {
                        if (bl11) {
                            throw new ProbekitException("Duplicate data item: className");
                        }
                        bl11 = true;
                    } else if (string3.equals("methodName")) {
                        if (bl12) {
                            throw new ProbekitException("Duplicate data item: methodName");
                        }
                        bl12 = true;
                    } else if (string3.equals("methodSig")) {
                        if (bl13) {
                            throw new ProbekitException("Duplicate data item: methodSig");
                        }
                        bl13 = true;
                    } else if (string3.equals("thisObject")) {
                        if (bl14) {
                            throw new ProbekitException("Duplicate data item: thisObject");
                        }
                        bl14 = true;
                    } else if (string3.equals("args")) {
                        if (bl15) {
                            throw new ProbekitException("Duplicate data item: args");
                        }
                        bl15 = true;
                    } else if (string3.equals("exceptionObject")) {
                        if (bl17) {
                            throw new ProbekitException("Duplicate data item: exceptionObject");
                        }
                        bl17 = true;
                        if (bl6 || bl9) {
                            throw new ProbekitException("Invalid data item: exceptionObject in entry/beforecall fragment");
                        }
                    } else if (string3.equals("returnedObject")) {
                        if (bl16) {
                            throw new ProbekitException("Duplicate data item: returnedObject");
                        }
                        bl16 = true;
                        if (bl6 || bl9 || bl8) {
                            throw new ProbekitException("Invalid data item: returnedObject in entry/beforecall/catch fragment");
                        }
                    } else if (string3.equals("isFinally")) {
                        if (bl18) {
                            throw new ProbekitException("Duplicate data item: isFinally");
                        }
                        bl18 = true;
                        if (!bl8) {
                            throw new ProbekitException("Invalid data item: isFinally in non-catch fragment");
                        }
                    } else {
                        throw new ProbekitException("Invalid data item type string: " + string3);
                    }
                    if (this.isValidJavaIdentifier(dataType1.getName())) continue;
                    throw new ProbekitException("Invalid Java identifier for data item: " + dataType1.getName());
                }
            }
            if (fragmentType1.getCode() != null && fragmentType1.getCode() != null && !fragmentType1.getCode().equals("")) continue;
            throw new ProbekitException("Invalid fragment: has no code");
        }
        object = probeType.getTarget().iterator();
        while (object.hasNext()) {
            string = (TargetType)object.next();
            String string4 = string.getType();
            if (string4 == null || string4.equals("")) {
                throw new ProbekitException("Invalid target/filter: missing type string");
            }
            if (!string4.equals("include") && !string4.equals("exclude")) {
                throw new ProbekitException("Unknown target type (not include or exclude): " + string.getType());
            }
            if (!this.hasWhitespace(string.getClassName()) && !this.hasWhitespace(string.getMethod()) && !this.hasWhitespace(string.getPackage()) && !this.hasWhitespace(string.getSignature())) continue;
            throw new ProbekitException("A target wildcard pattern contains a space, tab, or other whitespace character");
        }
        if (probeType.getControlKey() != null) {
            throw new ProbekitException("Probe uses controlKey, which is not yet implemented");
        }
        if (probeType.getInvocationObject() != null) {
            throw new ProbekitException("Probe uses invocationObject, which is not yet implemented");
        }
    }

    boolean isValidJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean hasWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getGeneratedSource() throws ProbekitException {
        if (this.compilerState == 0) {
            this.generateSource();
        }
        return this.generatedSource.toString();
    }

    public String getEngineScript() throws ProbekitException {
        if (this.compilerState == 0) {
            this.generateSource();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.probeDetailsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Iterator iterator2;
            Map.Entry entry = iterator.next();
            ProbeType probeType = (ProbeType)entry.getKey();
            ProbeDetails probeDetails = (ProbeDetails)entry.getValue();
            stringBuffer.append("REM " + probeDetails.commentName + lineSeparator);
            stringBuffer.append("PROBE" + lineSeparator);
            Iterator iterator3 = probeType.getTarget().iterator();
            while (iterator3.hasNext()) {
                String string3;
                String string4;
                iterator2 = (TargetType)iterator3.next();
                string2 = iterator2.getPackage();
                if (string2 == null || string2.equals("")) {
                    string2 = "*";
                }
                if ((string = iterator2.getClassName()) == null || string.equals("")) {
                    string = "*";
                }
                if ((string4 = iterator2.getMethod()) == null || string4.equals("")) {
                    string4 = "*";
                }
                if ((string3 = iterator2.getSignature()) == null || string3.equals("")) {
                    string3 = "*";
                }
                stringBuffer.append("RULE " + string2 + " " + string + " " + string4 + " " + string3 + " " + iterator2.getType() + lineSeparator);
            }
            iterator2 = probeType.getFragment().iterator();
            while (iterator2.hasNext()) {
                string2 = (FragmentType1)iterator2.next();
                stringBuffer.append("REF ");
                string = string2.getType().getName();
                int n = Compiler.FragTypeNameToNumber(string);
                if (string.equals("entry")) {
                    stringBuffer.append("ONENTRY ");
                } else if (string.equals("exit")) {
                    stringBuffer.append("ONEXIT ");
                } else if (string.equals("catch")) {
                    stringBuffer.append("ONCATCH ");
                } else if (string.equals("beforeCall")) {
                    stringBuffer.append("BEFORECALL ");
                } else if (string.equals("afterCall")) {
                    stringBuffer.append("AFTERCALL ");
                } else {
                    throw new ProbekitException("Unsupported fragment type; not entry, exit, or catch");
                }
                stringBuffer.append(this.getOuterClassName() + "$" + probeDetails.uniqueClassName + " ");
                stringBuffer.append(probeDetails.fragmentDetails[n].functionName + " ");
                stringBuffer.append(probeDetails.fragmentDetails[n].signature + " ");
                stringBuffer.append(probeDetails.fragmentDetails[n].argumentList + lineSeparator);
            }
        }
        return stringBuffer.toString();
    }

    private void generateSource() throws ProbekitException {
        this.verify();
        try {
            ProbeDetails probeDetails;
            Object object;
            Iterator iterator;
            Object object2;
            this.controlKeysSet = new HashSet();
            this.generatedSource = new StringBuffer();
            this.probeDetailsMap = new HashMap();
            this.nextSerialNumber = 0;
            this.compilerState = 0;
            this.emitln("// generated source from ProbeKit compiler");
            this.emitln("// List of probes in this probe set:");
            Iterator iterator2 = this.probekits.iterator();
            while (iterator2.hasNext()) {
                object2 = (ProbekitType)iterator2.next();
                iterator = object2.getProbe().iterator();
                while (iterator.hasNext()) {
                    object = (ProbeType)iterator.next();
                    probeDetails = new ProbeDetails((ProbeType)object);
                    this.probeDetailsMap.put(object, probeDetails);
                    this.emitln("//   " + probeDetails.commentName);
                }
            }
            this.emitln("// \"imports\" specifications for probes (if any):");
            this.emitImports();
            this.emitln("class " + this.getOuterClassName() + " {");
            this.emitln("  public static boolean placeHolderForGlobalEnableFlag = true;");
            this.emitln("  // Probe control keys appear below (if any):");
            this.emitControlKeyDeclarations();
            object2 = this.probekits.iterator();
            while (object2.hasNext()) {
                iterator = (ProbekitType)object2.next();
                object = iterator.getProbe().iterator();
                while (object.hasNext()) {
                    probeDetails = (ProbeType)object.next();
                    this.emitOneProbeInnerClass((ProbeType)probeDetails);
                }
            }
            this.emitln("}");
            this.compilerState = 1;
        }
        catch (RuntimeException runtimeException) {
            throw new ProbekitException(runtimeException.toString());
        }
    }

    private void setDirtyState() {
        this.generatedSource = null;
        this.compilerState = 0;
    }

    private void emit(String string) {
        this.generatedSource.append(string);
    }

    private void emitln(String string) {
        this.generatedSource.append(string);
        this.generatedSource.append(lineSeparator);
    }

    private String getOuterClassName() {
        return this.classPrefix + "_probe";
    }

    private static int FragTypeNameToNumber(String string) throws ProbekitException {
        if (string.equals("entry")) {
            return 0;
        }
        if (string.equals("exit")) {
            return 1;
        }
        if (string.equals("catch")) {
            return 2;
        }
        if (string.equals("beforeCall")) {
            return 3;
        }
        if (string.equals("afterCall")) {
            return 4;
        }
        throw new ProbekitException("Bad fragment type name: " + string);
    }

    private void emitImports() throws ProbekitException {
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            ProbekitType probekitType = (ProbekitType)iterator.next();
            Iterator iterator2 = probekitType.getProbe().iterator();
            while (iterator2.hasNext()) {
                ProbeType probeType = (ProbeType)iterator2.next();
                if (probeType.getImport() == null) continue;
                Object v = this.probeDetailsMap.get(probeType);
                if (v == null) {
                    throw new ProbekitException("Internal error: failed to find details for probe");
                }
                ProbeDetails probeDetails = (ProbeDetails)v;
                Iterator iterator3 = probeType.getImport().iterator();
                while (iterator3.hasNext()) {
                    ImportType importType = (ImportType)iterator3.next();
                    this.emitln("import " + importType.getText() + "; // from " + probeDetails.commentName);
                }
            }
        }
    }

    private void emitControlKeyDeclarations() throws ProbekitException {
        Object object;
        ProbekitType probekitType;
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            probekitType = (ProbekitType)iterator.next();
            object = probekitType.getProbe().iterator();
            while (object.hasNext()) {
                ProbeType probeType = (ProbeType)object.next();
                Object v = this.probeDetailsMap.get(probeType);
                if (v == null) {
                    throw new ProbekitException("Internal error: failed to find details for probe");
                }
                ProbeDetails probeDetails = (ProbeDetails)v;
                if (probeType.getControlKey() == null) continue;
                String string = probeType.getControlKey().getName();
                this.controlKeysSet.add(string);
                this.emitln("  // key " + string + " is used by " + probeDetails.commentName);
            }
        }
        probekitType = this.controlKeysSet.iterator();
        while (probekitType.hasNext()) {
            object = (String)probekitType.next();
            this.emitln("  public static boolean " + (String)object + " = true;");
        }
    }

    private String getNextProbeClassName() {
        String string = PROBE_INNER_CLASS_NAME_PREFIX + this.nextSerialNumber;
        ++this.nextSerialNumber;
        return string;
    }

    private void emitOneProbeInnerClass(ProbeType probeType) throws ProbekitException {
        Object v = this.probeDetailsMap.get(probeType);
        if (v == null) {
            throw new ProbekitException("Internal error: failed to find details for probe");
        }
        ProbeDetails probeDetails = (ProbeDetails)v;
        this.emitln("  // Class for probe " + probeDetails.commentName);
        probeDetails.uniqueClassName = this.getNextProbeClassName();
        this.emitln("  public static class " + probeDetails.uniqueClassName + " {");
        String string = probeType.getFragmentAtClassScope();
        if (string != null) {
            this.emitln("    // Fragment at class scope");
            this.emitln(string);
        }
        Iterator iterator = probeType.getFragment().iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3;
            FragmentType1 fragmentType1 = (FragmentType1)iterator.next();
            String string4 = fragmentType1.getType().getName();
            int n = Compiler.FragTypeNameToNumber(string4);
            String string5 = "_" + string4;
            probeDetails.fragmentDetails[n] = new ProbeDetails.FragmentDetails();
            probeDetails.fragmentDetails[n].functionName = string5;
            if (string4.equals("entry") && probeDetails.hasInvocationObject) {
                string3 = "Object";
                string2 = INVOCATION_OBJECT_TYPE_SIGNATURE;
            } else {
                string3 = "void";
                string2 = "V";
            }
            this.emitln("    public static " + string3 + " " + string5 + " (");
            boolean bl = true;
            probeDetails.fragmentDetails[n].signature = "(";
            probeDetails.fragmentDetails[n].argumentList = new String();
            int n2 = 0;
            while (n2 < dataItemDescs.length) {
                Iterator iterator2 = fragmentType1.getData().iterator();
                while (iterator2.hasNext()) {
                    DataType1 dataType1 = (DataType1)iterator2.next();
                    if (!dataType1.getType().getName().equals(Compiler.dataItemDescs[n2].typeName)) continue;
                    String string6 = dataType1.getName();
                    if (!bl) {
                        this.emitln(",");
                    }
                    this.emit("      " + Compiler.dataItemDescs[n2].typeType + " /*" + Compiler.dataItemDescs[n2].typeName + "*/ " + string6);
                    probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + Compiler.dataItemDescs[n2].typeSignature;
                    if (!bl) {
                        probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + ",";
                    }
                    probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + Compiler.dataItemDescs[n2].typeName;
                    bl = false;
                }
                ++n2;
            }
            if (probeDetails.hasInvocationObject && (string4.equals("catch") || string4.equals("exit"))) {
                if (!bl) {
                    this.emitln(",");
                }
                this.emit("      Object placeholder_for_invocation_object_name");
                probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + INVOCATION_OBJECT_TYPE_SIGNATURE;
            }
            this.emitln("      ) {");
            probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + ")" + string2;
            this.emitln("      // Internal signature for this method: " + probeDetails.fragmentDetails[n].signature);
            this.emitln("      if (!placeHolderForGlobalEnableFlag)");
            if (probeDetails.hasInvocationObject) {
                this.emitln("        return null;");
            } else {
                this.emitln("        return;");
            }
            if (probeType.getControlKey() != null) {
                this.emitln("      if (!" + probeType.getControlKey().getName() + ") return;");
            }
            if (probeDetails.hasInvocationObject && string4.equals("entry")) {
                this.emitln("      Object placeholder_for_invocation_object_name;");
            }
            this.emitln("//------------------ begin user-written fragment code ----------------");
            this.emitln(fragmentType1.getCode());
            this.emitln("//------------------- end user-written fragment code -----------------");
            if (probeDetails.hasInvocationObject && string4.equals("entry")) {
                this.emitln("      return placeholder_for_invocation_object_name;");
            }
            this.emitln("    }");
        }
        this.emitln("  }");
    }

    class ControlKeyDescriptor {
        String key;
        String initialValue;

        ControlKeyDescriptor(String string, String string2) {
            this.key = string;
            this.initialValue = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof ControlKeyDescriptor) {
                return this.key.equals(((ControlKeyDescriptor)object).key);
            }
            return false;
        }
    }

    public static class ProbeDetails {
        public String commentName = "";
        public String uniqueClassName = "";
        public boolean hasInvocationObject = false;
        public FragmentDetails[] fragmentDetails = new FragmentDetails[5];

        public ProbeDetails(ProbeType probeType) {
            this.commentName = probeType.getName() == null || probeType.getName().size() == 0 ? "unnamed_probe" : ((NameType)probeType.getName().get(0)).getText();
        }

        static class FragmentDetails {
            public String functionName;
            public String signature;
            public String argumentList;

            FragmentDetails() {
            }
        }
    }

    private static class DataItemDesc {
        public String typeName;
        public String typeType;
        public String typeSignature;

        public DataItemDesc(String string, String string2, String string3) {
            this.typeName = string;
            this.typeType = string2;
            this.typeSignature = string3;
        }
    }

    public static class ProbekitException
    extends Exception {
        public ProbekitException(String string) {
            super(string);
        }
    }
}

