/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class StatisticalModelEditor
extends EditorPart
implements DisposeListener {
    IEditorSite site;
    IFileEditorInput input;
    IFile file;
    ArrayList sdroots = new ArrayList();
    StatisticalModelGraphViewer agg_editor;
    ArrayList disposables = new ArrayList();

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.site = iEditorSite;
        this.input = (IFileEditorInput)iEditorInput;
        EditorPlugin.DBG.info("StatisticalModelEditor: got input");
        this.file = this.input.getFile();
        try {
            EditorPlugin.DBG.info("StatisticalModelEditor: loading file");
            this.load(this.file);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            throw new PartInitException("An error occurred:" + coreException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new PartInitException("An I/O error occurred:" + iOException.getMessage());
        }
        if (this.sdroots.size() == 0) {
            throw new PartInitException("no statistical model found in file");
        }
    }

    public void load(IFile iFile) throws CoreException, IOException {
        if (iFile == null) {
            throw new IOException("NULL file!");
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: creating ResourceSetImpl");
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        EditorPlugin.DBG.info("StatisticalModelEditor file URI:" + uRI);
        if (uRI == null) {
            throw new IOException("Null fileURI while loading statistical model");
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: getting resource");
        Resource resource = resourceSetImpl.getResource(uRI, false);
        if (resource == null) {
            EditorPlugin.DBG.info("StatisticalModelEditor: creating resource");
            resource = resourceSetImpl.createResource(uRI);
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: created resource");
        if (resource == null) {
            throw new IOException("NULL resource!");
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: created resource not NULL");
        resource.load(Collections.EMPTY_MAP);
        EditorPlugin.DBG.info("StatisticalModelEditor: loaded resource");
        EList eList = resource.getContents();
        EditorPlugin.DBG.info("StatisticalModelEditor: got contents of resource " + eList.size());
        int n = 0;
        while (n < eList.size()) {
            Object object = eList.get(n);
            if (object instanceof SDDescriptor) {
                EditorPlugin.DBG.info("StatisticalModelEditor: adding SDDescriptor as root");
                this.sdroots.add(object);
            } else if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                EList eList2 = eObject.eContents();
                int n2 = 0;
                while (n2 < eList2.size()) {
                    Object object2 = eList2.get(n2);
                    if (object2 instanceof SDDescriptor) {
                        EditorPlugin.DBG.info("StatisticalModelEditor: adding depth-1 child SDDescriptor as root");
                        this.sdroots.add(object2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void createPartControl(Composite composite) {
        System.gc();
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        double d = l2 - l;
        d /= (double)l2;
        System.err.println("MEMORY USED = " + (l2 - l) / 1024L + "k (" + (d *= 100.0) + "%)");
        composite.addDisposeListener((DisposeListener)this);
        EditorPlugin.DBG.info("CALLING TAB FOLDER CONSTRUCTOR");
        this.agg_editor = new StatisticalModelGraphViewer(composite, 0, false);
        int n = 0;
        while (n < this.sdroots.size()) {
            EditorPlugin.DBG.info("THIS ADD MODEL CALL HAS BEEN REMOVED - THIS CLASS IS OBSOLETE AND SHOULD NOT BE BEING USED");
            ++n;
        }
        this.disposables.add(this.agg_editor);
    }

    public void dispose() {
        super.dispose();
        EditorPlugin.DBG.info(((Object)((Object)this)).getClass() + ":disposed");
        int n = 0;
        while (n < this.disposables.size()) {
            try {
                Object e = this.disposables.get(n);
                if (e != null) {
                    if (e instanceof Widget) {
                        ((Widget)e).dispose();
                    } else if (e instanceof Color) {
                        ((Color)e).dispose();
                    } else if (e instanceof Image) {
                        ((Image)e).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(e);
                        }
                        catch (Throwable throwable) {
                            EditorPlugin.DBG.info("Class not found when disposing of " + e);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
    }
}

