/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TextGraph;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class IndicatorLineGraph
implements TextGraph,
IndicatorSource {
    int type = 0;
    TimeZoomSlider xslider;
    ZoomSlider yslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    double source_val = Double.MAX_VALUE;

    public double getIndicatorLocation() {
        return this.source_val;
    }

    public void setIndicatorSource(IndicatorSource indicatorSource) {
    }

    public IndicatorLineGraph(TimeZoomSlider timeZoomSlider, ZoomSlider zoomSlider, Color color) {
        this.xslider = timeZoomSlider;
        this.yslider = zoomSlider;
        this.fg_col = color;
    }

    public BasicGraphSource getGraphSource() {
        return null;
    }

    public double getXMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getXMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double getYMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return Double.POSITIVE_INFINITY;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider timeZoomSlider) {
        this.xslider = timeZoomSlider;
    }

    public void setYSlider(ZoomSlider zoomSlider) {
        this.yslider = zoomSlider;
    }

    public void setForeground(Color color) {
        this.fg_col = color;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int n) {
        this.line_width = n;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int n) {
        this.line_style = n;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setUseIndicator(boolean bl) {
    }

    public int getSourceType() {
        return this.type;
    }

    public void setSourceType(int n) {
        this.type = n;
    }

    public void setIndicatorLocation(double d) {
        this.source_val = d;
    }

    public void paintGraph(GC gC, int n, int n2, int n3, int n4) {
        this.paintGraph(gC, n, n2, n3, n4, 0);
    }

    public int paintGraph(GC gC, int n, int n2, int n3, int n4, int n5) {
        int n6 = gC.getFontMetrics().getHeight();
        gC.setForeground(this.fg_col);
        gC.setLineWidth(this.line_width);
        gC.setLineStyle(this.line_style);
        int n7 = (int)this.source_val;
        long l = (long)this.xslider.pixel2Value(n7);
        if (this.type == 0) {
            n7 = (int)this.xslider.value2Pixel(this.source_val);
            l = (long)this.source_val;
        }
        if (n7 < n3) {
            gC.drawLine(n7, n2, n7, n2 + n4);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(simpleDateFormat.format(new Date(l)));
            gC.setForeground(this.yslider.getDisplay().getSystemColor(15));
            gC.drawString(stringBuffer.toString(), n7 + 2, n5 + n2 + 1, true);
            gC.setForeground(this.yslider.getDisplay().getSystemColor(2));
            gC.drawString(stringBuffer.toString(), n7 + 1, n5 + n2, true);
            if ((n5 += n6) + n6 > n4) {
                n5 = 0;
            }
        }
        return n5;
    }

    public void setStaticScaling(double d) {
    }

    public double getStaticScaling() {
        return 1.0;
    }
}

