/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.edit.datapool;

/**
 * Each {@link IDatapoolCell cell} in a {@link IDatapoolRecord record} has a 
 * unique variable association.  Logically a variable is the equivalent of a 
 * column in a datapool display.  Associated with each variable is a
 * {@link IDatapoolSuggestedType suggested type} that may be used by a datapool
 * editor to improve display and editing of individual cells.  The role may also
 * be used by an editor to control the type of data allowed in a particular
 * column in the display.
 * 
 * @see	IDatapool
 */
public interface IDatapoolVariable extends 
	org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable,
	INamedElement
{
	
	/**
	 * Define the {@link IDatapoolSuggestedType type} associated with this variable.
	 * 
	 * @param	suggestedType	The {@link IDatapoolSuggestedType type} associated 
	 *							with this variable.
	 * 
	 * @see #getSuggestedType()
	 */
	public void setSuggestedType(IDatapoolSuggestedType suggestedType);
	
	/**
	 * Define the role associated with a variable.
	 * 
	 * @param	role	The role to associate with a variable.
	 * 
	 * @see #getRole()
	 * @see	#ROLE_UNSPECIFIED
	 * @see	#ROLE_INPUT_DATA
	 * @see	#ROLE_OUTPUT_DATA
	 * @see	#ROLE_INPUT_OUTPUT_DATA
	 * @see	#ROLE_VERIFICATION_DATA
	 */
	public void setRole(int role);
	
}
