/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.*;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import org.eclipse.hyades.uml2sd.trace.preferences.ITraceInteractionPreferenceListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * The main plugin class to be used in the desktop.
 */
public class TraceSDPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static TraceSDPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public TraceSDPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle = descriptor.getResourceBundle();
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static TraceSDPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#initializeDefaultPreferences(org.eclipse.jface.preference.IPreferenceStore)
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(ITraceInteractionPreferenceListener.PAGE_SIZE, 128*1024);
	}
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = TraceSDPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * @return the resource bundle
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	/**
	 * @return the plugin id
	 */
	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}
	
	private static URL BASIC_URL = null;
	private static Hashtable images = null;
	/**
	 * Load image with that _name and return it
	 */
	public static Image getResourceImage( String _name )
	{
		if (getDefault() == null) {
			return null;
		}
		if (images != null) {
			Image img = (Image)images.get(_name);
			if (img != null &&
				!img.isDisposed()) {
//System.err.println("Optimizing for image "+_name);
				return img;
			}
		}
		if (BASIC_URL == null) {
			try {
				BASIC_URL =	new URL(getDefault().getDescriptor().getInstallURL(), "icons/"); //$NON-NLS-1$
			} catch (MalformedURLException e) {
				e.printStackTrace();
				return null;
			}
			images = new Hashtable();
		}
		ImageDescriptor imgd;
		try {
			URL url = new URL( BASIC_URL, _name);
			imgd = ImageDescriptor.createFromURL(url);
//System.err.println("Getting image "+url);
		} catch (MalformedURLException e) {
			imgd = ImageDescriptor.getMissingImageDescriptor();
//System.err.println("Missing image "+BASIC_URL+_name);
		}
		Image img = imgd.createImage();
		images.put(_name, img);
		return img;
	}

	public void startup() throws CoreException {
//System.err.println("Startup called");
		super.startup();
	}

	public void shutdown() throws CoreException {
		if (images == null)
			return;

		for (Iterator e = images.values().iterator(); e.hasNext();) {
			Object next = e.next();
			if (next instanceof Image && !((Image) next).isDisposed()) {
				((Image) next).dispose();
			}
		}

		images.clear();
		images = null;

		super.shutdown();
//System.err.println("Shutdown finished");
	}

}
