/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;

/**
 * This class aims to populate an Agent Interaction UML2 Sequence Diagram.
 */
public class AgentInteractions extends NoMessageInteractions {
	
	/**
	 * Categories:
	 * - only one for nodes
	 */
	public static final int CATEGORY_AGENT = 0;
	private static LifelineCategories[] traceCategories;
	static {
		traceCategories = new LifelineCategories[1];
		traceCategories[CATEGORY_AGENT] = new LifelineCategories();
		traceCategories[CATEGORY_AGENT].setName(TraceSDPlugin.getResourceString("STR_AGENT")); //$NON-NLS-1$
		traceCategories[CATEGORY_AGENT].setImage(new ImageImpl(TraceSDPlugin.getResourceImage("agent_run_obj.gif"))); //$NON-NLS-1$
	}
	
	/**
	 * @return
	 */
	protected void createFrame() {
		super.createFrame();
		frame.setLifelineCategories(traceCategories);
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#setFrameName()
	 */
	public void setFrameName() {
		frame.setName(TraceSDPlugin.getResourceString("STR_UML2SD_AGENT_INTERACTION")); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	protected EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getProcess().getAgent(); // TRCAgent
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	protected int getLifeLineCategory(EObject to) {
		return CATEGORY_AGENT;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	protected String getLifeLineTitle(EObject to, boolean long_) {
		TRCAgent agent = (TRCAgent)to;
		return agent.getRuntimeId(); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_AGENT_INTERACTION"); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.NoMessageInteractions#getEntryTime(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	protected double getEntryTime(TRCFullMethodInvocation mi) {
		if (mi == mi.getProcess().getInvocations().get(0)) {
			return TraceInteractionUtils.getAbsoluteEntryTime(mi.getProcess().getAgent());
		} else {
			return TraceInteractionUtils.getAbsoluteEntryTime(mi);
		}
	}
}
