/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;

/**
 * This class aims to populate a Process Interaction UML2 Sequence Diagram.
 */
public class ThreadInteractions extends NoMessageInteractions {
	
	/**
	 * Categories:
	 * - only one for threads
	 */
	public static final int CATEGORY_THREAD = 0;
	private static LifelineCategories[] traceCategories;
	static {
		traceCategories = new LifelineCategories[1];
		traceCategories[CATEGORY_THREAD] = new LifelineCategories();
		traceCategories[CATEGORY_THREAD].setName(TraceSDPlugin.getResourceString("STR_THREAD")); //$NON-NLS-1$
		traceCategories[CATEGORY_THREAD].setImage(new ImageImpl(TraceSDPlugin.getResourceImage("thread_obj.gif"))); //$NON-NLS-1$
	}
	
	/**
	 * @return
	 */
	protected void createFrame() {
		super.createFrame();
		frame.setLifelineCategories(traceCategories);
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#setFrameName()
	 */
	public void setFrameName() {
		if (currentProcesses != null && currentProcesses.size() == 1) {
			TRCProcess process = ((TraceProcess)currentProcesses.get(0)).getProcess();
			frame.setName(process.getAgent().getAgentProxy().getProcessProxy().getName()+
					  " [Pid "+process.getPid()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		} else {
			frame.setName(TraceSDPlugin.getResourceString("STR_SEVERAL_PROCESSES")); //$NON-NLS-1$
		}
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	protected EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getThread(); // TRCThread
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	protected int getLifeLineCategory(EObject to) {
		return CATEGORY_THREAD;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	protected String getLifeLineTitle(EObject to, boolean long_) {
		TRCThread thread = (TRCThread)to;
		return thread.getName() +
			   (long_ ? " "+TraceSDPlugin.getResourceString("STR_PROCESS")+" "+ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			   	thread.getProcess().getAgent().getAgentProxy().getProcessProxy().getName()+" [Pid "+thread.getProcess().getPid()+"]" : ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_THREAD_INTERACTION"); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.NoMessageInteractions#getEntryTime(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	protected double getEntryTime(TRCFullMethodInvocation mi) {
		if (mi == mi.getProcess().getInvocations().get(0)) {
			return TraceInteractionUtils.getAbsoluteEntryTime(mi.getThread());
		} else {
			return TraceInteractionUtils.getAbsoluteEntryTime(mi);
		}
	}
}
