/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;

/**
 * Utils
 */
public class TraceInteractionUtils {
	
	/**
	 * This method searches for the reference of the TRCProcess 
	 * selected in the profiling monitor view
	 */
	static public void searchTRCProcesses(EObject object, TraceProcesses list, IProgressMonitor monitor) {
		
		TRCAgent agent;
		
		if (monitor.isCanceled()) {
			return;
		}
		if (object instanceof TRCMonitor) {
			TRCMonitor m = (TRCMonitor)object;
			if (m.getNodes() == null ||
				m.getNodes().isEmpty()) {
				return;
			}
			for (Iterator i = m.getNodes().iterator(); i.hasNext() && !monitor.isCanceled(); ) {
				searchTRCProcesses((EObject)i.next(), list, monitor);
			}
		} else if (object instanceof TRCNode) {
			TRCNode n = (TRCNode)object;
			if (n.getProcessProxies() == null ||
				n.getProcessProxies().isEmpty()) {
				return;
			}
			for (Iterator i = n.getProcessProxies().iterator(); i.hasNext() && !monitor.isCanceled(); ) {
				searchTRCProcesses((EObject)i.next(), list, monitor);
			}
		} else if (object instanceof TRCProcessProxy) {
			TRCProcessProxy pp = (TRCProcessProxy)object;
			if (pp.getAgentProxies() == null ||
				pp.getAgentProxies().isEmpty()) {
				return;
			}
			for (Iterator i = pp.getAgentProxies().iterator(); i.hasNext() && !monitor.isCanceled(); ) {
				searchTRCProcesses((EObject)i.next(), list, monitor);
			}
		} else if (object instanceof TRCAgentProxy &&
				   ((TRCAgentProxy) object).getType().equals(HyadesConstants.PROFILE_AGENT_TYPE)) {
			agent = ((TRCAgentProxy) object).getAgent();
			TRCProcess process = TraceUtils.getProcess(agent);
			if (process != null && process.getInvocations() != null) {
				list.add(new TraceProcess(process));
			}
		}
	}

	/**
	 * @param methodInvocation
	 * @return
	 */
	public static double getAbsoluteEntryTime(TRCFullMethodInvocation methodInvocation) {
		return methodInvocation.getProcess().getAgent().getStartTime()+
			   methodInvocation.getProcess().getStartTime()+
			   methodInvocation.getEntryTime();
	}

	/**
	 * @param agent
	 * @return
	 */
	public static double getAbsoluteEntryTime(TRCAgent agent) {
		return agent.getStartTime();
	}

	/**
	 * @param process
	 * @return
	 */
	public static double getAbsoluteEntryTime(TRCProcess process) {
		return process.getAgent().getStartTime()+
			   process.getStartTime();
	}

	/**
	 * @param thread
	 * @return
	 */
	public static double getAbsoluteEntryTime(TRCThread thread) {
		return thread.getProcess().getAgent().getStartTime()+
		   	   thread.getProcess().getStartTime()+
			   thread.getStartTime();
	}

	/**
	 * @param methodInvocation
	 * @return
	 */
	public static double getAbsoluteExitTime(TRCFullMethodInvocation methodInvocation) {
		return methodInvocation.getProcess().getAgent().getStartTime()+
			   methodInvocation.getProcess().getStartTime()+
			   methodInvocation.getExitTime();
	}

	/**
	 * @param agent
	 * @return
	 */
	public static double getAbsoluteExitTime(TRCAgent agent) {
		return agent.getStopTime();
	}

	/**
	 * @param process
	 * @return
	 */
	public static double getAbsoluteExitTime(TRCProcess process) {
		return process.getAgent().getStartTime()+
			   process.getStopTime();
	}

	/**
	 * @param thread
	 * @return
	 */
	public static double getAbsoluteExitTime(TRCThread thread) {
		return thread.getProcess().getAgent().getStartTime()+
			   thread.getProcess().getStartTime()+
			   thread.getStopTime();
	}

	public static boolean matchCharacter(char c1, char c2, boolean isCaseSensitive) {
//		System.out.println(c1+" "+c2);
		return (c1 == c2) ||
			    (!isCaseSensitive &&	Character.toLowerCase(c1) == Character.toLowerCase(c2));
	}
			
	public static boolean matchCriteria(String s, Criteria criteria) {
		String r = criteria.getExpression();
//		System.err.println("Comparing "+s+" to "+r);
		int i, j;
		for (i = 0, j = 0; i < s.length() && j < r.length(); i++) {
			char sc = s.charAt(i), rc = r.charAt(j);
			if (rc == '*') {
				// TODO: should try to find the full fragment, not the first letter.
				if ((j+1) < r.length()) {
					if (matchCharacter(sc, r.charAt(j+1), criteria.isCaseSenstiveSelected())) {
						j += 2;
					} // else will look after
				} else {
					// trailing * -> everything matches
//		System.err.println("#1 true");
					return true;
				}
			} else if (rc == '?') {
				if ((j+1) < r.length()) {
					if (matchCharacter(s.charAt(i+1), r.charAt(j+1), criteria.isCaseSenstiveSelected())) {
						j++;
					} else {
//		System.err.println("#2 false");
						return false;
					}
				} else {
					// trailing ? -> one char matches
//		System.err.println(i+1 == s.length()?"#3 true":"#3 false");
					return i+1 == s.length();
				}
			} else if (!matchCharacter(sc, rc, criteria.isCaseSenstiveSelected())) {
//		System.err.println("#4 false");
				return false;
			} else {
				j++;
			}
		}
//		System.err.println(i == s.length() && (j == r.length() || (j+1 == r.length() && (r.charAt(j) == '*' || r.charAt(j) == '?')))?"#5 true":"#5 false");
		return i == s.length() && (j == r.length() ||
			   (j+1 == r.length() && (r.charAt(j) == '*' || r.charAt(j) == '?')));
	}
			

	
}
