/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace.util;


/**
 * This is the record for an invocation context.  For up-to-date descriptions of the tag attributes,
 * see Event Specification for the Java Profiler at <code>http://www.eclipse.org/hyades</code>.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class RecordInvocationContext {

    private final String nodeIdRef;
    private final String processIdRef;
    private final String agentIdRef;
    private final int threadIdRef;
    private final String ticket;
    private final long sequenceCounter;
    private String collationValue = null;
    private String traceIdRef = null;


    /**
     * Creates a record for an invocation context.
     * 
     * @param nodeIdRef         the UUID of the node on which the peer is
     * @param processIdRef      the UUID of the process on which the peer is
     * @param agentIdRef        the UUID of the agent on which the peer is
     * @param threadIdRef       the thread ID on which the peer runs
     * @param ticket            the ticket on the peer side
     * @param sequenceCounter   the sequence counter on the peer side
     */
    public RecordInvocationContext(String nodeIdRef, String processIdRef, String agentIdRef,
                                   int threadIdRef, String ticket, long sequenceCounter) {

        this.nodeIdRef = nodeIdRef;
        this.processIdRef = processIdRef;
        this.agentIdRef = agentIdRef;
        this.threadIdRef = threadIdRef;
        this.ticket = ticket;
        this.sequenceCounter = sequenceCounter;
    }


    /**
     * Converts this record into a string.
     * 
     * @return  this record as a string
     */
    public String toString() {

        return "<InvocationContext nodeIdRef=\"" + nodeIdRef + "\" processIdRef=\"" + processIdRef +
               "\" agentIdRef=\""+ agentIdRef + "\" threadIdRef=\"" + threadIdRef +
               "\" ticket=\"" + ticket + "\" sequenceCounter=\"" + sequenceCounter + "\"" +
               (collationValue == null ? "" : " collationValue=\"" + collationValue + "\"") +
               (traceIdRef == null ? "" : " traceIdRef=\"" + traceIdRef + "\"") + "/>";
    }


    public String getAgentIdRef() {
        return agentIdRef;
    }


    public String getCollationValue() {
        return collationValue;
    }


    public String getNodeIdRef() {
        return nodeIdRef;
    }


    public String getProcessIdRef() {
        return processIdRef;
    }


    public long getSequenceCounter() {
        return sequenceCounter;
    }


    public int getThreadIdRef() {
        return threadIdRef;
    }


    public String getTicket() {
        return ticket;
    }


    public String getTraceIdRef() {
        return traceIdRef;
    }


    public void setCollationValue(String collationValue) {
        this.collationValue = collationValue;
    }


    public void setTraceIdRef(String traceIdRef) {
        this.traceIdRef = traceIdRef;
    }
}
