/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.context.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.context.Component} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ComponentItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_COMP_DESCR");
	public static final String EXEC_CLASS = AcadEditorPlugin.getPlugin().getString("STR_COMP_EXECC");	
	public static final String NAME = AcadEditorPlugin.getPlugin().getString("STR_COMP_NAME");	
	public static final String LOG_LEVEL = AcadEditorPlugin.getPlugin().getString("STR_COMP_LOGL");	
	public static final String ROLE_DATE = AcadEditorPlugin.getPlugin().getString("STR_COMP_ROLECD");	
	public static final String ROLE_VERSION = AcadEditorPlugin.getPlugin().getString("STR_COMP_ROLEV");	
	public static final String ROLE_DESC = AcadEditorPlugin.getPlugin().getString("STR_COMP_ROLEVD");	
	public static final String IMPL_DATE = AcadEditorPlugin.getPlugin().getString("STR_COMP_IMPLCD");	
	public static final String IMPL_VERSION = AcadEditorPlugin.getPlugin().getString("STR_COMP_IMPLV");	
	public static final String IMPL_DESCR = AcadEditorPlugin.getPlugin().getString("STR_COMP_IMPLVD");	
	public static final String UNIQUE_ID = AcadEditorPlugin.getPlugin().getString("STR_COMP_ID");	
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDescriptionPropertyDescriptor(object);
			addExecutableClassPropertyDescriptor(object);
			addImplementationCreationDatePropertyDescriptor(object);
			addImplementationVersionPropertyDescriptor(object);
			addImplementationVersionDescriptionPropertyDescriptor(object);
			addLoggingLevelPropertyDescriptor(object);
			addNamePropertyDescriptor(object);
			addRolePropertyDescriptor(object);
			addRoleCreationDatePropertyDescriptor(object);
			addRoleVersionPropertyDescriptor(object);
			addRoleVersionDescriptionPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_DESCR", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Executable Class feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addExecutableClassPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_EXECC"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_EXECC", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_ExecutableClass(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Implementation Creation Date feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addImplementationCreationDatePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_IMPLCD"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_IMPLCD", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_ImplementationCreationDate(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Implementation Version feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addImplementationVersionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_IMPLV"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_IMPLV", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_ImplementationVersion(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Implementation Version Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addImplementationVersionDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_IMPLVD"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_IMPLVD", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_ImplementationVersionDescription(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Logging Level feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addLoggingLevelPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_LOGL"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_LOGL", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_LoggingLevel(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_NAME"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_NAME", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRolePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_ROLE"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_ROLE", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_Role(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role Creation Date feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRoleCreationDatePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_ROLECD"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_ROLECD", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_RoleCreationDate(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role Version feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRoleVersionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_ROLEV"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_ROLEV", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_RoleVersion(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role Version Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRoleVersionDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_ROLEVD"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_ROLEVD", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_RoleVersionDescription(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_COMP_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_COMP_ID", "_UI_Component_type"),
				 ContextPackage.eINSTANCE.getComponent_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ContextPackage.eINSTANCE.getComponent_Component());
		}
		return childrenReferences;
	}


	/**
	 * This returns Component.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_COMPONENT);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((Component)object).getName();
		return label == null || label.length() == 0 ?
			getString("_UI_Component_type") :
			getString("_UI_Component_type") + " " + label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(Component.class)) {
			case ContextPackage.COMPONENT__COMPONENT:
			case ContextPackage.COMPONENT__DESCRIPTION:
			case ContextPackage.COMPONENT__EXECUTABLE_CLASS:
			case ContextPackage.COMPONENT__IMPLEMENTATION_CREATION_DATE:
			case ContextPackage.COMPONENT__IMPLEMENTATION_VERSION:
			case ContextPackage.COMPONENT__IMPLEMENTATION_VERSION_DESCRIPTION:
			case ContextPackage.COMPONENT__LOGGING_LEVEL:
			case ContextPackage.COMPONENT__NAME:
			case ContextPackage.COMPONENT__ROLE:
			case ContextPackage.COMPONENT__ROLE_CREATION_DATE:
			case ContextPackage.COMPONENT__ROLE_VERSION:
			case ContextPackage.COMPONENT__ROLE_VERSION_DESCRIPTION:
			case ContextPackage.COMPONENT__UNIQUE_ID: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
/*
		newChildDescriptors.add
			(createChildParameter
				(ContextPackage.eINSTANCE.getComponent_Component(),
				 ContextFactory.eINSTANCE.createComponent()));
				 */
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
