/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.context.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.context.ContextType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ContextTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	public static final String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_DESCR");
	public static final String UNIQUE_ID = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ID");
	public static final String EXEC_CLASS = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_EXECC");	
	public static final String NAME = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_NAME");	
	public static final String LOG_LEVEL = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_LOGL");	
	public static final String ROLE_DATE = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLECD");	
	public static final String ROLE_VERSION = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLEV");	
	public static final String ROLE_DESC = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_ROLEVD");	
	public static final String IMPL_DATE = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLCD");	
	public static final String IMPL_VERSION = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLV");	
	public static final String IMPL_DESCR = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTT_IMPLVD");	
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContextTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_DESCR", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Executable Class feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addExecutableClassPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_EXECC"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_EXECC", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_ExecutableClass(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Implementation Creation Date feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addImplementationCreationDatePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_IMPLCD"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_IMPLCD", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_ImplementationCreationDate(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Implementation Version feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addImplementationVersionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_IMPLV"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_IMPLV", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_ImplementationVersion(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Implementation Version Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addImplementationVersionDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_IMPLVD"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_IMPLVD", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_ImplementationVersionDescription(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Logging Level feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addLoggingLevelPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_LOGL"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_LOGL", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_LoggingLevel(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_NAME"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_NAME", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRolePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_ROLE"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_ROLE", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_Role(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role Creation Date feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRoleCreationDatePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_ROLECD"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_ROLECD", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_RoleCreationDate(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role Version feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRoleVersionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_ROLEV"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_ROLEV", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_RoleVersion(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Role Version Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addRoleVersionDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_ROLEVD"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_ROLEVD", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_RoleVersionDescription(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTT_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTT_ID", "_UI_ContextType_type"),
				 ContextPackage.eINSTANCE.getContextType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ContextPackage.eINSTANCE.getContextType_Component());
		}
		return childrenReferences;
	}


	/**
	 * This returns ContextType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		
		if(object instanceof Component)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_COMPONENT);
		
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_CONTEXT);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((ContextType)object).getName();
		return label == null || label.length() == 0 ?
			getString("_UI_ContextType_type") :
			getString("_UI_ContextType_type") + " " + label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(ContextType.class)) {
			case ContextPackage.CONTEXT_TYPE__DESCRIPTION:
			case ContextPackage.CONTEXT_TYPE__EXECUTABLE_CLASS:
			case ContextPackage.CONTEXT_TYPE__IMPLEMENTATION_CREATION_DATE:
			case ContextPackage.CONTEXT_TYPE__IMPLEMENTATION_VERSION:
			case ContextPackage.CONTEXT_TYPE__IMPLEMENTATION_VERSION_DESCRIPTION:
			case ContextPackage.CONTEXT_TYPE__LOGGING_LEVEL:
			case ContextPackage.CONTEXT_TYPE__NAME:
			case ContextPackage.CONTEXT_TYPE__ROLE:
			case ContextPackage.CONTEXT_TYPE__ROLE_CREATION_DATE:
			case ContextPackage.CONTEXT_TYPE__ROLE_VERSION:
			case ContextPackage.CONTEXT_TYPE__ROLE_VERSION_DESCRIPTION:
			case ContextPackage.CONTEXT_TYPE__UNIQUE_ID:
			case ContextPackage.CONTEXT_TYPE__COMPONENT: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
		newChildDescriptors.add
		(createChildParameter
			(ContextPackage.eINSTANCE.getContextType_Component(),
			 ContextFactory.eINSTANCE.createComponent()));
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
