/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.provider;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RuleElementTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuleElementTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Id feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ELEM_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_ELEM_ID", "_UI_RuleElementType_type"),
				 ParserPackage.eINSTANCE.getRuleElementType_Id(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Index feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addIndexPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ELEM_INDEX"),
				 getString("_UI_PropertyDescriptor_description", "STR_ELEM_INDEX", "_UI_RuleElementType_type"),
				 ParserPackage.eINSTANCE.getRuleElementType_Index(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ELEM_NAME"),
				 getString("_UI_PropertyDescriptor_description", "STR_ELEM_NAME", "_UI_RuleElementType_type"),
				 ParserPackage.eINSTANCE.getRuleElementType_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ParserPackage.eINSTANCE.getRuleElementType_RuleElement());
			childrenReferences.add(ParserPackage.eINSTANCE.getRuleElementType_RuleAttribute());
		}
		return childrenReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EReference getChildReference(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildReference(object, child);
	}


	/**
	 * This returns RuleElementType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object)
	{
		if(object instanceof RuleAttributeType)	
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_ATTRIBUTE);
		
		if(object instanceof RuleElementType)
		{
			if(AcadEditorPlugin.INSTANCE.getCBEElements().get(((RuleElementType)object).getName()) == null)
				return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_NESTING);					
			else
				return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_ELEMENT);			
		}
		
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_ELEMENT);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object) {
		String label = ((RuleElementType)object).getName();
		return label == null || label.length() == 0 ?
			"" : label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(RuleElementType.class)) {
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ELEMENT:
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ATTRIBUTE:
			case ParserPackage.RULE_ELEMENT_TYPE__ID:
			case ParserPackage.RULE_ELEMENT_TYPE__INDEX:
			case ParserPackage.RULE_ELEMENT_TYPE__NAME: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
		
		Object cbeObject = AcadEditorPlugin.INSTANCE.getElementDefinitionForType((RuleElementType)object);
		if(cbeObject != null)
		{
			if(cbeObject instanceof XSDElementDeclaration)
				collectElementDescriptors(newChildDescriptors, cbeObject);
			else if(cbeObject instanceof XSDComplexTypeDefinition)
				collectComplexTypeDescriptors(newChildDescriptors, (XSDComplexTypeDefinition)cbeObject);
			else if(cbeObject instanceof XSDTypeDefinition)
				collectAbstractTypeDescriptors(newChildDescriptors, (XSDTypeDefinition)cbeObject);
			else if(cbeObject instanceof XSDWildcard)
			{
				RuleAttributeType ruleAtribute = ParserFactory.eINSTANCE.createRuleAttributeType();
				ruleAtribute.setName(((XSDWildcard)cbeObject).getStringLexicalNamespaceConstraint());
				ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
				ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
				
				newChildDescriptors.add
					(createChildParameter
						(ParserPackage.eINSTANCE.getRuleElementType_RuleAttribute(),
						ruleAtribute));
				
			}
			
		}
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}

	/**
	 * 
	 * @param newChildDescriptors
	 * @param ctype
	 */
	protected void collectAbstractTypeDescriptors(Collection newChildDescriptors, XSDTypeDefinition ctype)
	{
		Object inheritedTypes = AcadEditorPlugin.INSTANCE.getInheritedTypes(ctype);
		if(inheritedTypes == null)
			return;
			
		ArrayList list = (ArrayList)inheritedTypes;
		for(int idx=0; idx<list.size(); idx++)
		{
			XSDTypeDefinition def = (XSDTypeDefinition)list.get(idx);
			if(def instanceof XSDComplexTypeDefinition)
			{
				RuleElementType element = ParserFactory.eINSTANCE.createRuleElementType();
				element.setName(def.getName());
				newChildDescriptors.add
					(createChildParameter
						(ParserPackage.eINSTANCE.getRuleElementType_RuleElement(),				
						 element));	
						 
				AcadEditorPlugin.INSTANCE.createRequiredAttributes(element, def);		 
						 
			}
		}
	}

	/**
	 * 
	 * @param newChildDescriptors
	 * @param ctype
	 */
	protected void collectComplexTypeDescriptors(Collection newChildDescriptors, XSDComplexTypeDefinition ctype)
	{
		XSDComplexTypeContent tdef = ctype.getContentType();
			
		if(tdef != null && tdef instanceof XSDParticle)
		{
			XSDParticleContent pcontent = ((XSDParticle)tdef).getContent();
			if(pcontent instanceof XSDModelGroup)
			{
				collectModelGroupDescriptors(newChildDescriptors, (XSDModelGroup)pcontent);
			}
				
		}	
			
		//add attributes
		EList attrs = ctype.getAttributeUses();
		for(int i = 0; i<attrs.size(); i++)
		{
			RuleAttributeType ruleAtribute = ParserFactory.eINSTANCE.createRuleAttributeType();
			ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
			ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
			ruleAtribute.setName(((XSDAttributeUse)attrs.get(i)).getAttributeDeclaration().getName());
			newChildDescriptors.add
				(createChildParameter
					(ParserPackage.eINSTANCE.getRuleElementType_RuleAttribute(),
					ruleAtribute));
				
		}
		
	}
	
	protected void collectModelGroupDescriptors(Collection newChildDescriptors, XSDModelGroup group)
	{
		EList tcontents = group.getContents();
				
		for(int i=0; i<tcontents.size(); i++)
		{
			XSDParticle obj = (XSDParticle)tcontents.get(i);
						
			XSDTerm odecl = obj.getTerm();
			if(odecl instanceof XSDElementDeclaration)
			{
				XSDElementDeclaration edecl = (XSDElementDeclaration)odecl;
							
				RuleElementType element = ParserFactory.eINSTANCE.createRuleElementType();
				element.setName(edecl.getName());
				newChildDescriptors.add
					(createChildParameter
						(ParserPackage.eINSTANCE.getRuleElementType_RuleElement(),				
						 element));	
						 
				AcadEditorPlugin.INSTANCE.createRequiredAttributes(element, edecl.getType());		 

			}
			else if(odecl instanceof XSDModelGroup)
			{
				collectModelGroupDescriptors(newChildDescriptors, (XSDModelGroup)odecl);
			}
		    else if(odecl instanceof XSDWildcard)
		    {
		    	XSDWildcard wcard = (XSDWildcard)odecl;
		    	String name = wcard.getStringLexicalNamespaceConstraint();
		    
				RuleElementType element = ParserFactory.eINSTANCE.createRuleElementType();
				element.setName(name);
				newChildDescriptors.add
					(createChildParameter
						(ParserPackage.eINSTANCE.getRuleElementType_RuleElement(),				
						 element));		
						 
		    }
		}
		
	}

	/**
	 * 
	 * @param newChildDescriptors
	 * @param object
	 * @param cbeObject
	 */
	protected void collectElementDescriptors(Collection newChildDescriptors, Object cbeObject)
	{
		if(cbeObject instanceof XSDElementDeclaration)
		{
			XSDElementDeclaration elem = (XSDElementDeclaration)cbeObject;
		
			XSDTypeDefinition type = elem.getTypeDefinition();
				
			if(type instanceof XSDComplexTypeDefinition)
			{
				XSDComplexTypeDefinition ctype = (XSDComplexTypeDefinition)type;
				if(ctype.isAbstract())
				{
					collectAbstractTypeDescriptors(newChildDescriptors, type);
					return;
				}

				collectComplexTypeDescriptors(newChildDescriptors, ctype);		
			}
			else if(type instanceof XSDSimpleTypeDefinition)
			{
				//this is an attribute array
				RuleAttributeType ruleAtribute = ParserFactory.eINSTANCE.createRuleAttributeType();
				ruleAtribute.setName(elem.getName());
				ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
				ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
				
				newChildDescriptors.add
					(createChildParameter
						(ParserPackage.eINSTANCE.getRuleElementType_RuleAttribute(),
						ruleAtribute));
			
			}
			
		}
		else if(cbeObject instanceof XSDWildcard)
		{
			//this is an attribute array
			RuleAttributeType ruleAtribute = ParserFactory.eINSTANCE.createRuleAttributeType();
			ruleAtribute.setName(((XSDWildcard)cbeObject).getStringLexicalNamespaceConstraint());
			ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
			ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
			
			newChildDescriptors.add
				(createChildParameter
					(ParserPackage.eINSTANCE.getRuleElementType_RuleAttribute(),
					ruleAtribute));
			
			
		}
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
