/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;

/**
 * @author Ernest Jessee
 */
public interface IExecutionHarnessDataProcessor extends DataProcessor
{
	/**
	 * @param proc
	 * @param agent
	 */
	public void init();	
	public String getName();
	public String getID();
	public ITest getTest();
	public void setControlAgent(Agent theAgent);
	public Agent getControlAgent();
	public void setInitData(ITest theTest,String hostName,String executionResultName, String executionResultLocation,String portNumber);
	public void setProcess(Process process);
	public Process getProcess();
}
