/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.wizard.RunWizard;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class RunJavaWizard extends RunWizard implements IRunnableWithProgress
{
	private String error;
	private String executionResultLocation;
	private String executionResultName;
	private static HashMap controlInterfacesMap = new HashMap();
	boolean runWizard;

	public RunJavaWizard()
	{
		super();
	}

	public boolean doPerformFinish()
	{
		error = null;
		runWizard = true;

		// Get the location for the execution result		
		executionResultLocation = getContainerPath().toString();
		executionResultName = getExecutionResultName();

		try
		{
			// run operation in separate thread and make it canceable
			new ProgressMonitorDialog(getShell()).run(true, true, this);
		}
		catch (InvocationTargetException e)
		{
			runWizard = false;
			MessageDialog.openError(getShell(), TestJavaPlugin.getString("W_ERROR"), e.getTargetException().getMessage());
			return false;
		}
		catch (InterruptedException e)
		{
			runWizard = false;
			return false;
		}

		runWizard = false;
		if (error != null && !error.equals(""))
		{
			String errMsg = TestJavaPlugin.getString("CONNECTION_FAIL_TEXT");
			CFGArtifactLocationPair pair = (CFGArtifactLocationPair)getDeployment().getArtifactLocations().get(0);
			if(pair != null)
				errMsg = StringUtil.replace(errMsg, "%1", pair.getLocation().getName());
	
			Status err1 = new Status(IStatus.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, error, null);
	
			ErrorDialog.openError(getShell(), TestJavaPlugin.getString("TEST_ERR_MSG"), errMsg, err1);
			return false;
		}

		IWorkbenchPage page = TestJavaPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
		if (page != null)
		{
			try
			{
				page.showView(ExecutionNavigator.ID);
			}
			catch (Exception exc)
			{
				TestUIPlugin.logError(exc);
			}

		}

		return true;
	}

	public void run(IProgressMonitor mon)
	{
		runWizard = true;
		(new RefreshUI(mon)).start();

		ITestSuite testSuite = null;
		if (getTest() instanceof ITestSuite)
			testSuite = (ITestSuite)getTest();
		else if(getTest() instanceof ITestCase)
			testSuite = ((ITestCase)getTest()).getOwner();

		String machineName = null;
		
		String port = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.LOCALHOST_PORT);
		StringBuffer bufError = new StringBuffer();

		IExecutor controlInterface = new TestExecutionHarness().launchTest((ITestSuite)testSuite, 
				(ITest)getTest(), getDeployment(), port, executionResultLocation, executionResultName, 
				true, false, bufError);
		error = bufError.toString();
		
		if ( controlInterface != null )
		{
			setControlInterface(executionResultLocation, executionResultName, controlInterface);	
		}
		
		mon.done();
	}

	class RefreshUI extends Thread
	{
		IProgressMonitor monitor;

		public RefreshUI(IProgressMonitor mon)
		{
			super("run_test");
			monitor = mon;
		}

		public void run()
		{
			while (runWizard)
			{
				try
				{
					Display d = Display.getDefault();
					d.asyncExec(new Runnable()
					{
						public void run()
						{

							if (monitor.isCanceled())
							{
								if (monitor.isCanceled())
								{
									runWizard = false;
									throw new OperationCanceledException();
								}
							}

						}
					});

					sleep(2000);
				}
				catch (InterruptedException exc)
				{
				}
			}
		}
	}
	
	/**
	 * This method sets the control interface for a test that has been launched.
	 * The test is uniquely identified by the combination of 
	 * executionResultLocation and executionResultName, uniqueness of 
	 * executionResultName being guaranteed within a given workbench by virtue
	 * of the timestamp in the name.
	 * 
	 * @param executionResultLocation
	 * @param executionResultName
	 * @param controlInterface
	 */
	protected void setControlInterface(	String executionResultLocation, 
			String executionResultName,	IExecutor controlInterface )
	{
		String key = executionResultLocation + "/" + executionResultName;
		controlInterfacesMap.put(key, controlInterface);
		
		// TODO: register a state change listener here to remove the interface
		// from the map when the executor dies.
	}
	
	/**
	 * This method retrieves a control interface (IExecutor) for a test that
	 * has been launched.  The caller who retrieves this interface must verify
	 * the state of the IExecutor before using it to control the running test.
	 * 
	 * @param executionResultLocation
	 * @param executionResultName
	 * @return
	 */
	protected IExecutor getControlInterface( String executionResultLocation, 
			String executionResultName)
	{
		String key = executionResultLocation + "/" + executionResultName;
		return (IExecutor)controlInterfacesMap.get(key);
	}
}
