/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Full Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * TRCFullMethodInvocation carries attributes about a method invocation that are used when the agent was tracking performance information about each function call.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getStackDepth <em>Stack Depth</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getEntryTime <em>Entry Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getExitTime <em>Exit Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getTicket <em>Ticket</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getOverhead <em>Overhead</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getCallerLineNo <em>Caller Line No</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCFullMethodInvocation()
 * @model 
 * @generated
 */
public interface TRCFullMethodInvocation extends TRCMethodInvocation{
	/**
	 * Returns the value of the '<em><b>Stack Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Stack Depth</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The true stack depth for this invocation, even counting stack frames which don't appear in the TRCMethodInvocation.invokes chain.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stack Depth</em>' attribute.
	 * @see #setStackDepth(short)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCFullMethodInvocation_StackDepth()
	 * @model 
	 * @generated
	 */
	short getStackDepth();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getStackDepth <em>Stack Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stack Depth</em>' attribute.
	 * @see #getStackDepth()
	 * @generated
	 */
	void setStackDepth(short value);

	/**
	 * Returns the value of the '<em><b>Entry Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Entry Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Method entry time, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Entry Time</em>' attribute.
	 * @see #setEntryTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCFullMethodInvocation_EntryTime()
	 * @model 
	 * @generated
	 */
	double getEntryTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getEntryTime <em>Entry Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Entry Time</em>' attribute.
	 * @see #getEntryTime()
	 * @generated
	 */
	void setEntryTime(double value);

	/**
	 * Returns the value of the '<em><b>Exit Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Exit Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Method exit time, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Exit Time</em>' attribute.
	 * @see #setExitTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCFullMethodInvocation_ExitTime()
	 * @model 
	 * @generated
	 */
	double getExitTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getExitTime <em>Exit Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Exit Time</em>' attribute.
	 * @see #getExitTime()
	 * @generated
	 */
	void setExitTime(double value);

	/**
	 * Returns the value of the '<em><b>Ticket</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ticket</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A ticket is a sequential incremental counter used to correlate invocations that can not be sorted by time alone. This allows for events to arrive out of sequence or for invocations to filtered out and skipped.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Ticket</em>' attribute.
	 * @see #setTicket(long)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCFullMethodInvocation_Ticket()
	 * @model 
	 * @generated
	 */
	long getTicket();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getTicket <em>Ticket</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ticket</em>' attribute.
	 * @see #getTicket()
	 * @generated
	 */
	void setTicket(long value);

	/**
	 * Returns the value of the '<em><b>Overhead</b></em>' attribute.
	 * The default value is <code>"0.0"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Overhead</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Overhead introduced by tracing the application. Tracking this time on a per-invocation basis is important because the cost of tracing is not uniform.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Overhead</em>' attribute.
	 * @see #setOverhead(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCFullMethodInvocation_Overhead()
	 * @model default="0.0"
	 * @generated
	 */
	double getOverhead();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getOverhead <em>Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Overhead</em>' attribute.
	 * @see #getOverhead()
	 * @generated
	 */
	void setOverhead(double value);

	/**
	 * Returns the value of the '<em><b>Caller Line No</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Caller Line No</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The source line number of the calling statement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Caller Line No</em>' attribute.
	 * @see #setCallerLineNo(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCFullMethodInvocation_CallerLineNo()
	 * @model 
	 * @generated
	 */
	int getCallerLineNo();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation#getCallerLineNo <em>Caller Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Caller Line No</em>' attribute.
	 * @see #getCallerLineNo()
	 * @generated
	 */
	void setCallerLineNo(int value);

} // TRCFullMethodInvocation
