/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Package</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedCalls <em>Inherited Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedBaseTime <em>Inherited Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getTotalSize <em>Total Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getTotalInstances <em>Total Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getCollectedSize <em>Collected Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getCollectedInstances <em>Collected Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getClasses <em>Classes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getSubPackages <em>Sub Packages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCPackage#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage()
 * @model 
 * @extends org.eclipse.hyades.loaders.trace.IDeltaManager
 * @generated NOT
 */
public interface TRCPackage extends EObject, org.eclipse.hyades.loaders.trace.IDeltaManager{
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * The default value is <code>"Default"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The fully qualified name of the package. The dot separated notation is used. This may become more complex once further language-neutrality is added to the model.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_Name()
	 * @model default="Default"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Base Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Base Time</em>' attribute.
	 * @see #setBaseTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_BaseTime()
	 * @model 
	 * @generated
	 */
	double getBaseTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getBaseTime <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Base Time</em>' attribute.
	 * @see #getBaseTime()
	 * @generated
	 */
	void setBaseTime(double value);

	/**
	 * Returns the value of the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Cumulative Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of this owning element + all methods called from these methods (but owned by other elements)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cumulative Time</em>' attribute.
	 * @see #setCumulativeTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_CumulativeTime()
	 * @model 
	 * @generated
	 */
	double getCumulativeTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getCumulativeTime <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cumulative Time</em>' attribute.
	 * @see #getCumulativeTime()
	 * @generated
	 */
	void setCumulativeTime(double value);

	/**
	 * Returns the value of the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Calls</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * number of calls to the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Calls</em>' attribute.
	 * @see #setCalls(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_Calls()
	 * @model 
	 * @generated
	 */
	int getCalls();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getCalls <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Calls</em>' attribute.
	 * @see #getCalls()
	 * @generated
	 */
	void setCalls(int value);

	/**
	 * Returns the value of the '<em><b>Inherited Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inherited Calls</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of calls to methods defined in superclasses of classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Calls</em>' attribute.
	 * @see #setInheritedCalls(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_InheritedCalls()
	 * @model 
	 * @generated
	 */
	int getInheritedCalls();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedCalls <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Calls</em>' attribute.
	 * @see #getInheritedCalls()
	 * @generated
	 */
	void setInheritedCalls(int value);

	/**
	 * Returns the value of the '<em><b>Inherited Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inherited Base Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods defined in superclasses of this classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Base Time</em>' attribute.
	 * @see #setInheritedBaseTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_InheritedBaseTime()
	 * @model 
	 * @generated
	 */
	double getInheritedBaseTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedBaseTime <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Base Time</em>' attribute.
	 * @see #getInheritedBaseTime()
	 * @generated
	 */
	void setInheritedBaseTime(double value);

	/**
	 * Returns the value of the '<em><b>Inherited Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inherited Cumulative Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of classes from the owning element + all methods called from the methods defined in superclasses of classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Cumulative Time</em>' attribute.
	 * @see #setInheritedCumulativeTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_InheritedCumulativeTime()
	 * @model 
	 * @generated
	 */
	double getInheritedCumulativeTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Cumulative Time</em>' attribute.
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 */
	void setInheritedCumulativeTime(double value);

	/**
	 * Returns the value of the '<em><b>Total Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Total Size</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The total size of memory allocated
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Size</em>' attribute.
	 * @see #setTotalSize(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_TotalSize()
	 * @model 
	 * @generated
	 */
	int getTotalSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getTotalSize <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Size</em>' attribute.
	 * @see #getTotalSize()
	 * @generated
	 */
	void setTotalSize(int value);

	/**
	 * Returns the value of the '<em><b>Total Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Total Instances</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of instances created
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Instances</em>' attribute.
	 * @see #setTotalInstances(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_TotalInstances()
	 * @model 
	 * @generated
	 */
	int getTotalInstances();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getTotalInstances <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Instances</em>' attribute.
	 * @see #getTotalInstances()
	 * @generated
	 */
	void setTotalInstances(int value);

	/**
	 * Returns the value of the '<em><b>Collected Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collected Size</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The total size of memory garbage collected
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collected Size</em>' attribute.
	 * @see #setCollectedSize(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_CollectedSize()
	 * @model 
	 * @generated
	 */
	int getCollectedSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getCollectedSize <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collected Size</em>' attribute.
	 * @see #getCollectedSize()
	 * @generated
	 */
	void setCollectedSize(int value);

	/**
	 * Returns the value of the '<em><b>Collected Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collected Instances</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of instances garbage collected
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collected Instances</em>' attribute.
	 * @see #setCollectedInstances(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_CollectedInstances()
	 * @model 
	 * @generated
	 */
	int getCollectedInstances();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getCollectedInstances <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collected Instances</em>' attribute.
	 * @see #getCollectedInstances()
	 * @generated
	 */
	void setCollectedInstances(int value);

	/**
	 * Returns the value of the '<em><b>Process</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCProcess#getPackages <em>Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process</em>' container reference.
	 * @see #setProcess(TRCProcess)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_Process()
	 * @see org.eclipse.hyades.models.trace.TRCProcess#getPackages
	 * @model opposite="packages" required="true"
	 * @generated
	 */
	TRCProcess getProcess();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getProcess <em>Process</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process</em>' container reference.
	 * @see #getProcess()
	 * @generated
	 */
	void setProcess(TRCProcess value);

	/**
	 * Returns the value of the '<em><b>Classes</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCClass}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCClass#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Classes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Classes</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_Classes()
	 * @see org.eclipse.hyades.models.trace.TRCClass#getPackage
	 * @model type="org.eclipse.hyades.models.trace.TRCClass" opposite="package" containment="true"
	 * @generated
	 */
	EList getClasses();

	/**
	 * Returns the value of the '<em><b>Sub Packages</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCPackage}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCPackage#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sub Packages</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sub Packages</em>' reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_SubPackages()
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getParent
	 * @model type="org.eclipse.hyades.models.trace.TRCPackage" opposite="parent"
	 * @generated
	 */
	EList getSubPackages();

	/**
	 * Returns the value of the '<em><b>Parent</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCPackage#getSubPackages <em>Sub Packages</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent</em>' reference.
	 * @see #setParent(TRCPackage)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCPackage_Parent()
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getSubPackages
	 * @model opposite="subPackages"
	 * @generated
	 */
	TRCPackage getParent();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCPackage#getParent <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent</em>' reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(TRCPackage value);

} // TRCPackage
