/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.models.trace.*;

import org.eclipse.hyades.models.trace.util.LLUnitData;

import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCGCRootType;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodProperties;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TraceFactoryImpl extends EFactoryImpl implements TraceFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TraceFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case TracePackage.TRC_OBJECT: return createTRCObject();
			case TracePackage.TRC_CLASS: return createTRCClass();
			case TracePackage.TRC_METHOD_INVOCATION: return createTRCMethodInvocation();
			case TracePackage.TRC_PROCESS: return createTRCProcess();
			case TracePackage.TRC_THREAD: return createTRCThread();
			case TracePackage.TRC_METHOD: return createTRCMethod();
			case TracePackage.TRC_PACKAGE: return createTRCPackage();
			case TracePackage.TRC_COLLECTION_BOUNDARY: return createTRCCollectionBoundary();
			case TracePackage.TRC_CLASS_LOADER: return createTRCClassLoader();
			case TracePackage.TRC_SOURCE_INFO: return createTRCSourceInfo();
			case TracePackage.TRC_HEAP_OBJECT: return createTRCHeapObject();
			case TracePackage.TRC_FULL_TRACE_OBJECT: return createTRCFullTraceObject();
			case TracePackage.TRC_TRACE_OBJECT: return createTRCTraceObject();
			case TracePackage.TRC_FULL_HEAP_OBJECT: return createTRCFullHeapObject();
			case TracePackage.TRC_OBJECT_REFERENCE: return createTRCObjectReference();
			case TracePackage.TRC_HEAP_DUMP: return createTRCHeapDump();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION: return createTRCAggregatedMethodInvocation();
			case TracePackage.TRC_FULL_METHOD_INVOCATION: return createTRCFullMethodInvocation();
			case TracePackage.TRC_HEAP_ROOT: return createTRCHeapRoot();
			case TracePackage.TRC_ARRAY_CLASS: return createTRCArrayClass();
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE: return createTRCAggregatedObjectReference();
			case TracePackage.TRC_THREAD_EVENT: return createTRCThreadEvent();
			case TracePackage.TRC_THREAD_SLEEPING_EVENT: return createTRCThreadSleepingEvent();
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT: return createTRCThreadWaitingForObjectEvent();
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT: return createTRCThreadWaitingForLockEvent();
			case TracePackage.TRC_THREAD_RUNNING_EVENT: return createTRCThreadRunningEvent();
			case TracePackage.TRC_THREAD_DEAD_EVENT: return createTRCThreadDeadEvent();
			case TracePackage.TRC_METHOD_WITH_LL_DATA: return createTRCMethodWithLLData();
			case TracePackage.TRC_SOURCE_INFO_WITH_LL_DATA: return createTRCSourceInfoWithLLData();
			case TracePackage.TRC_LINE_COVERAGE_DATA: return createTRCLineCoverageData();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case TracePackage.TRC_PRIMITIVE_TYPE:
				return TRCPrimitiveType.get(initialValue);
			case TracePackage.TRC_SIGNATURE_NOTATION:
				return TRCSignatureNotation.get(initialValue);
			case TracePackage.TRC_METHOD_PROPERTIES:
				return TRCMethodProperties.get(initialValue);
			case TracePackage.TRCGC_ROOT_TYPE:
				return TRCGCRootType.get(initialValue);
			case TracePackage.EOBJECT_ID:
				return createEObjectIDFromString(eDataType, initialValue);
			case TracePackage.EMETHOD_ID:
				return createEMethodIDFromString(eDataType, initialValue);
			case TracePackage.ECLASS_ID:
				return createEClassIDFromString(eDataType, initialValue);
			case TracePackage.LL_UNIT_DATA:
				return createLLUnitDataFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case TracePackage.TRC_PRIMITIVE_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case TracePackage.TRC_SIGNATURE_NOTATION:
				return instanceValue == null ? null : instanceValue.toString();
			case TracePackage.TRC_METHOD_PROPERTIES:
				return instanceValue == null ? null : instanceValue.toString();
			case TracePackage.TRCGC_ROOT_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case TracePackage.EOBJECT_ID:
				return convertEObjectIDToString(eDataType, instanceValue);
			case TracePackage.EMETHOD_ID:
				return convertEMethodIDToString(eDataType, instanceValue);
			case TracePackage.ECLASS_ID:
				return convertEClassIDToString(eDataType, instanceValue);
			case TracePackage.LL_UNIT_DATA:
				return convertLLUnitDataToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject createTRCObject() {
		TRCObjectImpl trcObject = new TRCObjectImpl();
		return trcObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass createTRCClass() {
		TRCClassImpl trcClass = new TRCClassImpl();
		return trcClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation createTRCMethodInvocation() {
		TRCMethodInvocationImpl trcMethodInvocation = new TRCMethodInvocationImpl();
		return trcMethodInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess createTRCProcess() {
		TRCProcessImpl trcProcess = new TRCProcessImpl();
		return trcProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread createTRCThread() {
		TRCThreadImpl trcThread = new TRCThreadImpl();
		return trcThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod createTRCMethod() {
		TRCMethodImpl trcMethod = new TRCMethodImpl();
		return trcMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage createTRCPackage() {
		TRCPackageImpl trcPackage = new TRCPackageImpl();
		return trcPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCCollectionBoundary createTRCCollectionBoundary() {
		TRCCollectionBoundaryImpl trcCollectionBoundary = new TRCCollectionBoundaryImpl();
		return trcCollectionBoundary;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClassLoader createTRCClassLoader() {
		TRCClassLoaderImpl trcClassLoader = new TRCClassLoaderImpl();
		return trcClassLoader;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfo createTRCSourceInfo() {
		TRCSourceInfoImpl trcSourceInfo = new TRCSourceInfoImpl();
		return trcSourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapObject createTRCHeapObject() {
		TRCHeapObjectImpl trcHeapObject = new TRCHeapObjectImpl();
		return trcHeapObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFullTraceObject createTRCFullTraceObject() {
		TRCFullTraceObjectImpl trcFullTraceObject = new TRCFullTraceObjectImpl();
		return trcFullTraceObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject createTRCTraceObject() {
		TRCTraceObjectImpl trcTraceObject = new TRCTraceObjectImpl();
		return trcTraceObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFullHeapObject createTRCFullHeapObject() {
		TRCFullHeapObjectImpl trcFullHeapObject = new TRCFullHeapObjectImpl();
		return trcFullHeapObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectReference createTRCObjectReference() {
		TRCObjectReferenceImpl trcObjectReference = new TRCObjectReferenceImpl();
		return trcObjectReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump createTRCHeapDump() {
		TRCHeapDumpImpl trcHeapDump = new TRCHeapDumpImpl();
		return trcHeapDump;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAggregatedMethodInvocation createTRCAggregatedMethodInvocation() {
		TRCAggregatedMethodInvocationImpl trcAggregatedMethodInvocation = new TRCAggregatedMethodInvocationImpl();
		return trcAggregatedMethodInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFullMethodInvocation createTRCFullMethodInvocation() {
		TRCFullMethodInvocationImpl trcFullMethodInvocation = new TRCFullMethodInvocationImpl();
		return trcFullMethodInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapRoot createTRCHeapRoot() {
		TRCHeapRootImpl trcHeapRoot = new TRCHeapRootImpl();
		return trcHeapRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCArrayClass createTRCArrayClass() {
		TRCArrayClassImpl trcArrayClass = new TRCArrayClassImpl();
		return trcArrayClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAggregatedObjectReference createTRCAggregatedObjectReference() {
		TRCAggregatedObjectReferenceImpl trcAggregatedObjectReference = new TRCAggregatedObjectReferenceImpl();
		return trcAggregatedObjectReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadEvent createTRCThreadEvent() {
		TRCThreadEventImpl trcThreadEvent = new TRCThreadEventImpl();
		return trcThreadEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadSleepingEvent createTRCThreadSleepingEvent() {
		TRCThreadSleepingEventImpl trcThreadSleepingEvent = new TRCThreadSleepingEventImpl();
		return trcThreadSleepingEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadWaitingForObjectEvent createTRCThreadWaitingForObjectEvent() {
		TRCThreadWaitingForObjectEventImpl trcThreadWaitingForObjectEvent = new TRCThreadWaitingForObjectEventImpl();
		return trcThreadWaitingForObjectEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadWaitingForLockEvent createTRCThreadWaitingForLockEvent() {
		TRCThreadWaitingForLockEventImpl trcThreadWaitingForLockEvent = new TRCThreadWaitingForLockEventImpl();
		return trcThreadWaitingForLockEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadRunningEvent createTRCThreadRunningEvent() {
		TRCThreadRunningEventImpl trcThreadRunningEvent = new TRCThreadRunningEventImpl();
		return trcThreadRunningEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThreadDeadEvent createTRCThreadDeadEvent() {
		TRCThreadDeadEventImpl trcThreadDeadEvent = new TRCThreadDeadEventImpl();
		return trcThreadDeadEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodWithLLData createTRCMethodWithLLData() {
		TRCMethodWithLLDataImpl trcMethodWithLLData = new TRCMethodWithLLDataImpl();
		return trcMethodWithLLData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfoWithLLData createTRCSourceInfoWithLLData() {
		TRCSourceInfoWithLLDataImpl trcSourceInfoWithLLData = new TRCSourceInfoWithLLDataImpl();
		return trcSourceInfoWithLLData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCLineCoverageData createTRCLineCoverageData() {
		TRCLineCoverageDataImpl trcLineCoverageData = new TRCLineCoverageDataImpl();
		return trcLineCoverageData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Long createEObjectIDFromString(EDataType eDataType, String initialValue) {
		return (Long)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEObjectIDToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Integer createEMethodIDFromString(EDataType eDataType, String initialValue) {
		return (Integer)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEMethodIDToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Integer createEClassIDFromString(EDataType eDataType, String initialValue) {
		return (Integer)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEClassIDToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LLUnitData createLLUnitDataFromString(EDataType eDataType, String initialValue) {
		return (LLUnitData)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertLLUnitDataToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TracePackage getTracePackage() {
		return (TracePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static TracePackage getPackage() {
		return TracePackage.eINSTANCE;
	}
} //TraceFactoryImpl
