package org.eclipse.hyades.collection.threadanalyzer;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DirectedGraph {
	
	public DirectedGraph(Hashtable _t)
	{
		_threads = _t;
		int maxThreads = _threads.size();
		objList = new Object[maxThreads];
		adjMat = new Object[maxThreads][maxThreads];
		
		nVerts = 0;
		for(int j=0; j<maxThreads; j++)
			for(int k=0; k<maxThreads;k++)
				adjMat[j][k] = null;
//		sortedArray = new int[maxThreads];
		threadNumbers = new Hashtable();
	}

	public void addVertex(Object thd)
	{
//		if(!_threads.contains(((Thd)thd)._threadId))
//		{
			threadNumbers.put(thd, new Integer(nVerts));
			objList[nVerts++] = thd;
//			System.out.print( " - " +((Thd)thd)._threadId);
//		}
//		System.out.println( " - > " +((Thd)thd)._threadId);
	}

	public void addEdge(Object edge, Object start, Object end)
	{
		int startInt = ((Integer)threadNumbers.get(start)).intValue();
		int endInt = ((Integer)threadNumbers.get(end)).intValue();
		adjMat[startInt][endInt] = edge;
	}

	public void displayVertex(int v)
	{
		System.out.print(((Thd)objList[v])._threadId);
	}

	public void findCircularPattern() //topological sort
	{
		int orig_nVerts = nVerts;

		while(nVerts > 0)
		{
			//get a vert with no successors, or -1
			int currentVertex = noSuccessors();
//      debugPrint("nVertSize" + nVerts + ".html");
			if(currentVertex == -1)  //must be a cycle
			{
//				System.out.println("There is a deadlock");
//				deadLockArray[nVerts-1] = threadList[currentVertex];
				return;
			}
			//insert vertex label in sorted array (start at end)
//			sortedArray[nVerts-1] = currentVertex;

			deleteVertex(currentVertex);
		}
		
//		System.out.print("nodes with dependencies: ");
//		for(int d=0; d<=adjMat.length; d++)
//			System.out.println(adjMat
		
		
//		System.out.print("nodes without dependencies: ");
//		for(int j=0; j<orig_nVerts; j++)
//			System.out.print(sortedArray[j]);
//		System.out.println("");
	}

	public int noSuccessors() //returns vert with no successors or -1 if no such verts
	{
		boolean isEdge;
		for(int row=0;row<nVerts; row++)
		{
			isEdge = false;
			for(int col=0; col<nVerts; col++)
			{
				if(adjMat[row][col] != null)
				{
					isEdge = true;
					break; //this vertex has a successor, try another
				}
			}
		if(!isEdge) //if no edges
			return row; //has no successors
		}
		return -1; //no such vertex
	}

  public void deleteVertex(int delVert)
  { //michel - changed nVerts-1 to nVerts
    if(delVert != (nVerts - 1)) //if not last vertex
    {
      for(int j=delVert; j<nVerts-1; j++)
        objList[j] = objList[j+1];
      for(int row=delVert; row<nVerts-1; row++) 
        moveRowUp(row, nVerts);
      // we use nVerts-1 in moveColLeft because we now have 1 less row
      for(int col=delVert; col<nVerts-1; col++)
        moveColLeft(col, nVerts-1);
    }
    else {
      for(int i=0;i<nVerts;i++) {
        adjMat[delVert][i] = null;
        adjMat[i][delVert]  = null;      
      }
    }
    nVerts--;
  }

	private void moveRowUp(int row, int length)
	{
		for(int col=0; col<length; col++)
		{
			adjMat[row][col] = adjMat[row+1][col];
			adjMat[row+1][col] = null;
		}
	}

	private void moveColLeft(int col, int length)
	{
		for(int row=0; row<length; row++)
		{
			adjMat[row][col] = adjMat[row][col+1];
			adjMat[row][col+1] = null;
		}
	}
	
/*	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		Thd t;
		Hashtable results = this.getNotNullPairs();
		Integer i = null;
		Integer j = null;
		if( results != null ) 
		{
			Iterator iterator = results.keySet().iterator();
			while( iterator.hasNext() ) 
			{
				i = (Integer)iterator.next();
				j = (Integer)results.get(i);
				sb.append("[").append(i).append("][").append(j).append("]= ");
				sb.append(((Monitor)getObjectAt(i,j))._name);
				t = (Thd)getObjListObjectAt(i);
				sb.append(",").append(t._threadId);
				t = (Thd)getObjListObjectAt(j);
				sb.append(",").append(t._threadId);
				sb.append("\n");
			}
			
		}
		else
		{
			sb.append("**all null matrix**");
		}
		
		return sb.toString();
	}
*/	
	//for debugging only
  public void debugPrint()
  {
    System.out.println("<p>Printing Graph:---------------------</p><br><br>");
    
    
    //print legend
    System.err.println("<table>");
    for(int i=0;i<adjMat.length;i++) {
      System.err.println("\t<tr><td>"+i+"</td><td>"+(String)((Thd)objList[i])._name+"</td></tr>");
    }
    System.err.println("</table>");
    //print header
    System.err.println("<table>");
    System.err.println("\t<tr>");
    System.err.print("<td>&nbsp;</td>");
    for(int i=0; i<adjMat.length;i++) {
      System.err.print("<td>["+i+ "]</td>");
    }
    System.err.println("\t</tr>");    
    //print contents
    for(int i =0; i<adjMat.length; i++) {
      System.err.println("\t<tr>");
      System.err.print("<td>["+i+ "]</td>");
      for(int j=0;j<adjMat[i].length;j++) {
        if( adjMat[i][j] == null )
          System.err.print("<td>-</td>");
        else 
          System.err.print("<td>"+((Monitor)adjMat[i][j])._name+"</td>");
      }
      System.err.println("\t</tr>");
    }
    System.err.println("</table>");
  }
  
  public void debugPrint(String filename)
  {
    PrintStream p = null;
    try {
    
      p = new PrintStream( new FileOutputStream(filename));
    } 
    catch(Exception e) {
      e.printStackTrace();
      System.err.println("IO Error:: Printing to err stream anyway.");
      p = System.err;
    }
    p.println("<p>Printing Graph:---------------------</p><br><br>");
    
    
    //print legend
    p.println("<table>");
    for(int i=0;i<adjMat.length;i++) {
      p.println("\t<tr><td>"+i+"</td><td>"+(String)((Thd)objList[i])._name+"</td></tr>");
    }
    p.println("</table>");
    //print header
    p.println("<table>");
    p.println("\t<tr>");
    p.print("<td>&nbsp;</td>");
    for(int i=0; i<adjMat.length;i++) {
      p.print("<td>["+i+ "]</td>");
    }
    p.println("\t</tr>");   
    //print contents
    for(int i =0; i<adjMat.length; i++) {
      p.println("\t<tr>");
      p.print("<td>["+i+ "]</td>");
      for(int j=0;j<adjMat[i].length;j++) {
        if( adjMat[i][j] == null )
          p.print("<td>-</td>");
        else 
          p.print("<td>"+((Monitor)adjMat[i][j])._name+"</td>");
      }
      p.println("\t</tr>");
    }
    p.println("</table>");
  }

	
	public Object[] getObjectList()
	{
		return objList;
	}
	
	public Object[][] getResultMatrix()
	{
		return adjMat;
	}
	// returns an Object within the matrix
	public Object getObjectAt(int i, int j) 
	{
		if( adjMat != null && i < adjMat.length && j < adjMat[0].length ) 
		{
			return adjMat[i][j];
		}
		return null;
	}
	public Object getObjectAt(Integer i, Integer j) 
	{
		return getObjectAt(i.intValue(), j.intValue());
	}
	// returns an objList Object
	public Object getObjListObjectAt(int i)
	{
		if( objList != null && i < objList.length ) 
		{
			return objList[i];	
		}
		return null;
	}
	public Object getObjListObjectAt(Integer i) 
	{
		return getObjListObjectAt(i.intValue());
	}
	// gets the position of all not null pairs.
	// key = start object
	// value = end object
	public Vector getNotNullPairs() 
	{

		Map cyclicHelper = new HashMap();
		Vector tempResult = new Vector();
		tempResult.add(new Vector());
		Vector result = null;
//		tempResult.add(new Vector());
		
		//list of hanging threads that are not involved in a deadlock but are waiting on themselves.
    ((Vector)tempResult.get(0)).add("The following threads appear to be waiting on themselves.\n"
      + "Check to see if the application is simply in a timed wait or if it is going \n"
      + "to wait indefinitely.  Further information can be found by looking in the \n"
      + "Overall Thread Analysis section of this tool.\n");
    if( adjMat != null ) 
		{
      int selfWaiterCount = 0;
			for(int i = 0; i < adjMat.length; i++ ) 
			{
				for(int j =0; j < adjMat[0].length; j++) 
				{
					if( adjMat[i][j] != null )
					{
						//add self waiting threads to the vector to display results.
						if(i == j)
						{
              ((Thd)objList[i]).setSelfWaiter(true);
							// only add those threads that are not known self-waiters
							if( ! ((Thd)objList[i]).waitingForWork() ) 
              {
                selfWaiterCount++;
								((Vector)tempResult.get(0)).add( "Single-threaded waiter " + selfWaiterCount + ":\n"
                  + "\"" + ((Thd)objList[i])._name 
									+ "\" (TID:" 
									+_reversedTid.get( ( (Thd)objList[i])._threadId )
									+ ") is waiting on " + ((Monitor)adjMat[i][j])._name + "\n");
							}
						}
						else
						{
							cyclicHelper.put(new Integer(i), new Integer(j));
						}
																
					}
				}
	
			}
			
			// do cyclic checks via cyclicHelper Map
			//create new hashtable for each of the deadlocks and add those to the tempResultSet vector..
			Set keyset = cyclicHelper.keySet();
			Iterator itr = keyset.iterator();
			Integer i = null;
			Vector tempResultSet = new Vector();

			tempResultSet.add(new Hashtable());
			if( itr.hasNext() ) i = (Integer)itr.next();
			int currentTable = 0;
			Integer value = null;
			
			while( ! cyclicHelper.isEmpty() ) 
			{
				value = (Integer)cyclicHelper.get(i);
				((Hashtable)tempResultSet.get(currentTable)).put(i,value);
				cyclicHelper.remove(i);
				i = value;
				if ((Integer)cyclicHelper.get(i) == null && ! cyclicHelper.isEmpty())
				{
					itr = keyset.iterator(); // cannot call itr.next() unless we get a new iterator
					i = (Integer)itr.next();
					currentTable++;	
					tempResultSet.add(currentTable, new Hashtable());
				}				
			}
			
			//Create a vector of all the deadlock results and store them in deadlockResults vector.
			Vector deadlockResults = new Vector();
			Hashtable h = null;
			for(int k=0; k<tempResultSet.size(); k++)
			{
				itr = null;
				h = (Hashtable)tempResultSet.get(k);
				itr = h.keySet().iterator();
        Integer first = null;
				
				if( itr.hasNext() ) 
        {
          deadlockResults.add("Multi-threaded deadlock " + (k+1) +":\n");
          // Get the first element
          first = (Integer)itr.next();
          if (!((Thd)objList[first.intValue()]).isSelfWaiter())
          {
            // Given the current deadlock-detect algorithm, there probably
            // won't be any self-waiters found but...
            // Find the self-waiter if there is one.  We want to print the
            // self waiter out first, with the blocked threads following            
            while (itr.hasNext())
            {
              i = (Integer)itr.next();
              if (((Thd)objList[i.intValue()]).isSelfWaiter())
              {
                first = i;
                break;
              }
            }
          }
        } 
        i = null;
        while(h.size() > 0)
        {
          if (i == null)
          {
            // Get initial i
            i = first;
          }
          else 
          {
            // Move to the next thread in line.
            i = value;
          }
          // Get the waiting thread
          value = (Integer)h.get(i);
          h.remove(i);
          if (((Thd)objList[i.intValue()]).isSelfWaiter())
          {
            // Shouldn't happen, but just in case.
            deadlockResults.add("Thread \"" + ((Thd)objList[i.intValue()])._name 
              + "\" is a self-waiter.  As a result, this deadlock is NON-circular.\n");
          }
          deadlockResults.add( "\"" + ((Thd)objList[i.intValue()])._name 
                + "\" of (sys:" + ((Thd)objList[i.intValue()])._threadId + ") (TID:"
                +_reversedTid.get( ((Thd)objList[i.intValue()])._threadId )+ ")\n"
                +"\tHolding Resource: " + ((Monitor)adjMat[i.intValue()][value.intValue()])._name
                + "\n\tThread Waiting: \""
                +((Thd)objList[value.intValue()])._name + "\" (sys:"
                + ((Thd)objList[value.intValue()])._threadId + ") (TID:"
                + _reversedTid.get( ((Thd)objList[value.intValue()])._threadId ) + ")\n");        
        }
			}
			
			result = new Vector(deadlockResults.size() + ((Vector)tempResult.get(0)).size());
			result.add("\n\nDeadlock Detection Report\n------------------------\n");
//			if( (deadlockResults.size() > 0) || (tempResult.size() > 1))
      if( (deadlockResults.size() > 0) || (((Vector)tempResult.get(0)).size() > 1))  
			{
				deadlockExists = true;	
			}
      else
      {
        result.add("No deadlock(s) found.\n");
      }

    if(deadlockResults.size()>1)
      result.add("The following threads appear to be in a circular deadlock.\n"
          + "Further information can be found by looking in the Overall Thread Analysis\n"
          + "section of this tool.\n");
      // Output multi-threaded deadlocks before singe-threaded deadlocks
      result.addAll(deadlockResults);
			
			// only output if there is at least one thread in tempResult.get(0)
			// i.e. tempResult.get(0).size() is 1 with no threads to output due to
			// disclaimer printout at the beginning of this method()
			if( ((Vector)tempResult.get(0)).size() > 1 ){
				result.addAll((Vector)tempResult.get(0));
			}     

      result.add("------------------------");			
			return result;
		}
		
		return null;
	}
	public boolean getDeadlockExists() 
	{
		return deadlockExists;
	}	
	
	public void putReversedTid(Hashtable _rTid)
	{
		_reversedTid = _rTid;
	}
	
	private Object objList[]		= null;
	private Object adjMat[][]			= null;
	private int nVerts				= -1;
//	private int sortedArray[]		= null;
	private Hashtable threadNumbers 	= null;
	private Hashtable _threads			= null;
	private Hashtable _reversedTid		= null;
	private boolean deadlockExists 	= false;

}
