package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Vector;

/*
  
*/
public class TOSEntryPoint
{

   public TOSEntryPoint( StkEntry stkEntry )
   {
      _stkEntry = stkEntry;
      _threads = new Vector();
      _callers = new Vector();
   }

   String getName()
   {
      String sName = null;
      if( _stkEntry != null )
         sName = _stkEntry.getFQName();
      return sName;
   }

   public int numThreads()
   {
      return _threads.size();
   }

   public int numCallers()
   {
      return _callers.size();
   }

   public void addThread( Thd thd )
   {
      _threads.add( thd );
   }

   public Enumeration getThreadEnum()
   {
      Enumeration e = _threads.elements();
      return e;
   }

   public Thd getNextThread( Enumeration e )
   {
      Thd tRet = null;
      if( e.hasMoreElements() )
      {
         tRet = (Thd)e.nextElement();
      }
      return tRet;
   }

   public void addCaller( TOSEntryPointCaller caller )
   {
      _callers.add( caller );
   }

   public Enumeration getCallerEnum()
   {
      return _callers.elements();
   }

   public TOSEntryPointCaller getNextCaller( Enumeration e )
   {
      TOSEntryPointCaller tRet = null;
      if( e.hasMoreElements() )
      {
         tRet = (TOSEntryPointCaller)e.nextElement();
      }
      return tRet;
   }

   public void addThreadsNoDups( Vector thds )
   {
      // inefficient, but effective
      for( int i = 0; i < thds.size(); ++i )
      {
         Thd thd = (Thd)thds.elementAt( i );
         boolean found = false;
         for( int j = 0; j < _threads.size(); ++j )
         {
            Thd chkThd = (Thd)_threads.elementAt( j );
            if( chkThd.equals( thd ))
            {
               found = true;
               break;
            }
         }
         if( ! found )
         {
            _threads.add( thd );
         }
      }
   }

   private TOSEntryPoint() {}

   private StkEntry _stkEntry = null;
   protected Vector _threads = null;
   protected Vector _callers = null;

}

