package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Vector;

/* holds the original thread dump text */

public class ThreadDump implements Externalizable
{
   public static final int _curVersion = 1;
   public int _version = -1;

   public Enumeration getEnumerator()
   {
      Enumeration enum = _lines.elements();
      return enum;
   }

   public String getNextLine( Enumeration enum )
   {
      String sRet = null;
      if( enum.hasMoreElements() )
         sRet = (String)enum.nextElement();
      return sRet;
   }

   public void addLine( String line, int lineNo )
   {
      String lineNum = "" + lineNo;
      int spaces = 6-lineNum.length();
      
      for( int i = 0; i < spaces; ++i )
         lineNum = " " + lineNum;
      
      _lines.add( lineNum + ":" + line );
   }

   public ThreadDump()
   {
      _version = _curVersion;
      _lines = new Vector();
   }

   public void writeExternal( ObjectOutput out ) throws IOException
   {
      out.writeInt( _curVersion );
      out.writeObject( _lines );

   }
   
   public void readExternal( ObjectInput in ) throws IOException,ClassNotFoundException
   {
      _version = in.readInt();
      _lines = (Vector)in.readObject();
   }

   public int getSize()
   {
       return _lines.size();
   }

   public Vector getThreadDumpVector() //dipak
   {
                return _lines;
   }

   //private String dummyStreamTestVar = null;
   private Vector _lines = null;

}


