package org.eclipse.hyades.internal.config.generator;

public interface AgentControllerConfig extends ConfigElement {
	public final static String TAG = ConfigUtility.getString("Config.AgentControllerConfig.Tag");

	AgentControllerEnvironment addAgentControllerEnvironment(String conf);
	Application addApplication(String conf, String exe);
	Hosts addHosts(String conf);
	Agent addAgent(String conf, String name);
	Security addSecurity();
	Option addOption(String name);

	void setActiveConfiguration(String value);
	void setJvm(String value);
	void setLoggingDetail(String value);
	void setLoggingLevel(String value);
	void setPort(String value);
	void setSecurePort(String value);
	void setVersion(String value);

	AgentControllerEnvironment getAgentControllerEnvironment(String config);
	Application getApplication(String config, String exe);
	Agent getAgent(String config, String agentName);
	Security getSecurity();
	void removeSecurity();
}
