package org.eclipse.hyades.internal.config.generator;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.NodeList;

public class AgentControllerConfigImpl extends ConfigElementImpl implements AgentControllerConfig {

	public AgentControllerConfigImpl(CoreDocumentImpl doc) {
		super(doc, TAG);
	}

	public AgentControllerEnvironment addAgentControllerEnvironment(String conf) {
		AgentControllerEnvironmentImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new AgentControllerEnvironmentImpl(ownerDocument);
			newElem.setConfiguration(conf);
			appendChild(newElem);
		}
		return newElem;
	}

	public Application addApplication(String conf, String exe) {
		ApplicationImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new ApplicationImpl(ownerDocument);
			newElem.setConfiguration(conf);
			newElem.setExecutable(exe);
			appendChild(newElem);
		}
		return newElem;
	}

	public Hosts addHosts(String conf) {
		HostsImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new HostsImpl(ownerDocument);
			newElem.setConfiguration(conf);
			appendChild(newElem);
		}
		return newElem;
	}

	public Agent addAgent(String conf, String name) {
		AgentImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new AgentImpl(ownerDocument);
			newElem.setConfiguration(conf);
			newElem.setName(name);
			appendChild(newElem);
		}
		return newElem;
	}

	public Security addSecurity() {
		SecurityImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new SecurityImpl(ownerDocument);
			appendChild(newElem);
		}
		return newElem;
	}

	public Option addOption(String name) {
		OptionImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new OptionImpl(ownerDocument);
			newElem.setName(name);
			appendChild(newElem);
		}
		return newElem;
	}

	public void setConfiguration(String value) {
		// Do nothing, no such attribute in this class
	}

	public void setActiveConfiguration(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.ActiveConfig.Tag"), value);
	}

	public void setJvm(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.Jvm.Tag"), value);
	}

	public void setLoggingDetail(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.LoggingDetail.Tag"), value);
	}

	public void setLoggingLevel(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.LoggingLevel.Tag"), value);
	}

	public void setPort(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.Port.Tag"), value);
	}

	public void setSecurePort(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.SecurePort.Tag"), value);
	}

	public void setVersion(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.Version.Tag"), value);
	}

	public AgentControllerEnvironment getAgentControllerEnvironment(String config) {
		NodeList nodes = getChildNodes();

		if(nodes != null) {
			for(int i = 0; i < nodes.getLength(); i++) {
				String name = nodes.item(i).getNodeName();
				if(name.equals(AgentControllerEnvironment.TAG)) {
					// Get the configuration value
					String attrName = ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag");
					String existingValue = findAttrValue(nodes.item(i), attrName);

					if(existingValue.equals(config)) { // existing node has the same configuration
						return (AgentControllerEnvironment)nodes.item(i);
					}
				}
			}
		}

		return null;
	}

	public Application getApplication(String config, String exe) {
		NodeList nodes = getChildNodes();

		if(nodes != null) {
			for(int i = 0; i < nodes.getLength(); i++) {
				String name = nodes.item(i).getNodeName();
				if(name.equals(Application.TAG)) {
					// Get the configuration value
					String attrName = ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag");
					String existingValue = findAttrValue(nodes.item(i), attrName);

					if(existingValue.equals(config)) { // existing node has the same configuration
						// Compare the executable value
						attrName = ConfigUtility.getString("Config.Application.Executable.Tag");
						existingValue = findAttrValue(nodes.item(i), attrName);

						if(existingValue.equals(exe)) { // existing node has the same executable
							return (Application)nodes.item(i);
						}
					}
				}
			}
		}

		return null;
	}

	public Agent getAgent(String config, String agentName) {
		NodeList nodes = getChildNodes();

		if(nodes != null) {
			for(int i = 0; i < nodes.getLength(); i++) {
				String name = nodes.item(i).getNodeName();
				if(name.equals(Application.TAG)) {
					// Get the configuration value
					String attrName = ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag");
					String existingValue = findAttrValue(nodes.item(i), attrName);

					if(existingValue.equals(config)) { // existing node has the same configuration
						// Compare the executable value
						attrName = ConfigUtility.getString("Config.Agent.Name.Tag");
						existingValue = findAttrValue(nodes.item(i), attrName);

						if(existingValue.equals(agentName)) { // existing node has the same agent name
							return (Agent)nodes.item(i);
						}
					}
				}
			}
		}

		return null;
	}

	public Security getSecurity() {
		NodeList nodes = getChildNodes();

		if(nodes != null) {
			for(int i = 0; i < nodes.getLength(); i++) {
				String name = nodes.item(i).getNodeName();
				if(name.equals(Security.TAG)) {
					return (Security)nodes.item(i);
				}
			}
		}

		return null;
	}

	public void removeSecurity() {
		NodeList nodes = getChildNodes();

		if(nodes != null) {
			for(int i = 0; i < nodes.getLength(); i++) {
				String name = nodes.item(i).getNodeName();
				if(name.equals(Security.TAG)) {
					removeChild(nodes.item(i));
				}
			}
		}
	}

}
