package org.eclipse.hyades.internal.config.generator;

import org.apache.xerces.dom.CoreDocumentImpl;

public class ApplicationImpl extends ConfigElementImpl implements Application {

	public ApplicationImpl(CoreDocumentImpl doc) {
		super(doc, TAG);
	}

	public Parameter addParameter() {
		ParameterImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new ParameterImpl(ownerDocument);
			appendChild(newElem);
		}
		return newElem;
	}

	public Variable addVariable() {
		VariableImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new VariableImpl(ownerDocument);
			appendChild(newElem);
		}
		return newElem;
	}

	public void setExecutable(String value) {
		setAttribute(ConfigUtility.getString("Config.Application.Executable.Tag"), value);
	}

	public void setLocation(String value) {
		setAttribute(ConfigUtility.getString("Config.Application.Location.Tag"), value);
	}

	public void setPath(String value) {
		setAttribute(ConfigUtility.getString("Config.Application.Path.Tag"), value);
	}

}
