package org.eclipse.hyades.internal.config.generator;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ConfigElementImpl extends ElementImpl implements ConfigElement {

	public ConfigElementImpl() {
		super(null, "Unknown");
	}

	public ConfigElementImpl(CoreDocumentImpl doc, String name) {
		super(doc, name);
	}

	public void setConfiguration(String value) {
		setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag"), value);
	}

	/**
	 * This will append a child node to the element if it does not exist. Otherwise it will
	 * update the node information instead. It will use both the element name and the configuration
	 * attribute for comparison.
	 */
	public Node appendChild(Node node) {
		if(node != null) {
			Node existingNode = findNode(node);

			if(existingNode != null) { // found an existing node in the configuration
				Logger.out(ConfigUtility.getString("Config.Parser.Warning.ReplaceExistingNode") + " " + ConfigUtility.printElement(existingNode));
				replaceChild(node, existingNode);
			}
			else {
				super.appendChild(node);
			}
		}

		return node;
	}

	private Node findNode(Node newNode) {
		Node result = null;
		NodeList nodes = getChildNodes();

		if(nodes != null) {
			for(int i = 0; i < nodes.getLength(); i++) {
				String existingName = nodes.item(i).getNodeName();
				String newName = newNode.getNodeName();
				if(existingName.equals(newName)) {
					if(newName.equals(AgentControllerEnvironment.TAG) || newName.equals(Hosts.TAG)) {
						// Compare the configuration value
						String attrName = ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag");
						String existingValue = findAttrValue(nodes.item(i), attrName);
						String newValue = findAttrValue(newNode, attrName);
						if(existingValue.equals(newValue)) { // existing node has the same configuration
							result = nodes.item(i);
							break;
						}
					}
					else if(newName.equals(Application.TAG)) {
						// Compare the configuration value
						String attrName = ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag");
						String existingValue = findAttrValue(nodes.item(i), attrName);
						String newValue = findAttrValue(newNode, attrName);
						if(existingValue.equals(newValue)) { // existing node has the same configuration
							// Compare the executable value
							attrName = ConfigUtility.getString("Config.Application.Executable.Tag");
							existingValue = findAttrValue(nodes.item(i), attrName);
							newValue = findAttrValue(newNode, attrName);
							if(existingValue.equals(newValue)) { // existing node has the same executable
								result = nodes.item(i);
								break;
							}
						}
					}
					else if(newName.equals(Agent.TAG)) {
						// Compare the configuration value
						String attrName = ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag");
						String existingValue = findAttrValue(nodes.item(i), attrName);
						String newValue = findAttrValue(newNode, attrName);
						if(existingValue.equals(newValue)) { // existing node has the same configuration
							// Compare the agent name
							attrName = ConfigUtility.getString("Config.Agent.Name.Tag");
							existingValue = findAttrValue(nodes.item(i), attrName);
							newValue = findAttrValue(newNode, attrName);
							if(existingValue.equals(newValue)) { // existing node has the same agent name
								result = nodes.item(i);
								break;
							}
						}
					}
					else if(newName.equals(Option.TAG)) {
						// Compare the option name
						String attrName = ConfigUtility.getString("Config.Option.Name.Tag");
						String existingValue = findAttrValue(nodes.item(i), attrName);
						String newValue = findAttrValue(newNode, attrName);
						if(existingValue.equals(newValue)) { // existing node has the same option name
							result = nodes.item(i);
							break;
						}
					}
				}
			}
		}

		return result;
	}

	protected String findAttrValue(Node node, String attrName) {
		NamedNodeMap attrs = node.getAttributes();
		if(attrs != null) {
			for(int i = 0; i < attrs.getLength(); i++) {
				if(attrs.item(i).getNodeName().equals(attrName)) {
					return attrs.item(i).getNodeValue();
				}
			}
		}
		return new String();
	}

}
