package org.eclipse.hyades.internal.config.generator;

import java.io.FileOutputStream;
import java.io.PrintStream;

public class Logger {
	private static boolean debug = false;
	protected static PrintStream out = System.out;
	protected static PrintStream err = System.err;

	static {
		if(System.getProperty("debug") != null) {
			debug = true;
		}
	}

	public static void out(String str) {
		if(debug) {
			out.println("OUT Log: " + str);
		}
	}

	public static void err(String str) {
		if(debug) {
			err.println("ERR Log: " + str);
		}
	}

	public static void setDebug(boolean b) {
		debug = b;
	}

	public static void setLogFile(String string) {
		try {
			err = out = new PrintStream(new FileOutputStream(string), true);
		} catch (Exception e) {
			// Set it back to System.out and System.err
			out = System.out;
			err = System.err;
		}
	}
}
