package org.eclipse.hyades.internal.config.generator;

import org.apache.xerces.dom.CoreDocumentImpl;

public class OptionImpl extends ConfigElementImpl implements Option {

	public OptionImpl(CoreDocumentImpl doc) {
		super(doc, TAG);
	}

	public void setName(String value) {
		setAttribute(ConfigUtility.getString("Config.Option.Name.Tag"), value);
	}

	public String getName() {
		return getAttribute(ConfigUtility.getString("Config.Option.Name.Tag"));
	}

	public void setType(String value) {
		setAttribute(ConfigUtility.getString("Config.Option.Type.Tag"), value);
	}

	public String getType() {
		return getAttribute(ConfigUtility.getString("Config.Option.Type.Tag"));
	}

	public void setValue(String value) {
		setAttribute(ConfigUtility.getString("Config.Option.Value.Tag"), value);
	}

	public String getValue() {
		return getAttribute(ConfigUtility.getString("Config.Option.Value.Tag"));
	}

	public void setConfiguration(String value) {
		// Do nothing
	}

}
