package org.eclipse.hyades.internal.config.generator;

import org.apache.xerces.dom.CoreDocumentImpl;

public class SecurityImpl extends ConfigElementImpl implements Security {

	public SecurityImpl(CoreDocumentImpl doc) {
		super(doc, TAG);
	}

	public UserDefinition addUserDefinition() {
		UserDefinitionImpl newElem = null;
		if(ownerDocument != null) {
			newElem = new UserDefinitionImpl(ownerDocument);
			appendChild(newElem);
		}
		return newElem;
	}

	public void setAclEnabled(String value) {
		setAttribute(ConfigUtility.getString("Config.Security.AclEnabled.Tag"), value);
	}

	public void setClientAuthenticate(String value) {
		setAttribute(ConfigUtility.getString("Config.Security.ClientAuthenticate.Tag"), value);
	}

	public void setKeystore(String value) {
		setAttribute(ConfigUtility.getString("Config.Security.Keystore.Tag"), value);
	}

	public void setKeystoreManager(String value) {
		setAttribute(ConfigUtility.getString("Config.Security.KeystoreManager.Tag"), value);
	}

	public void setKeystorePassword(String value) {
		setAttribute(ConfigUtility.getString("Config.Security.KeystorePassword.Tag"), value);
	}

	public void setProvider(String value) {
		setAttribute(ConfigUtility.getString("Config.Security.Provider.Tag"), value);
	}

	public void setConfiguration(String value) {
		// Do nothing
	}
}
