package org.eclipse.hyades.logging.jvm.threadanalysis;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class ThreadDumpGeneratorImpl implements ThreadDumpGenerator {
	
	public DumpData dump(int pid) {
		return null;
	}

	public DumpData dump(String file) {
		DumpParser dParser = null;
		DumpData data = null;
		String[] args = {
				"dumpIn=" + file,
				"logLevel=ERROR",
				"reportType=NONE",
				"dumpInType=JAVACORE",
				"analyze=ALL"
			};

		try {
			(new DumpParser( false )).parseArgs(args); 	// needed before DumpParser.create() for logLevel
			DumpParser.setDumpInName(file);			// needed before dParser.parse()
			dParser = DumpParser.create(file);
			if(dParser != null) {
				data = new DumpData();
				data.setDumpParserClassName(dParser.getClass().getName());
				data.setInputFilename(file);
				data.setLogLevel(dParser.getLogLevel());
				dParser.parse(data);
				data.setDumpingJvmName(dParser.getDumpingJvmName());
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		return data;
	}

	public DumpData dump(String server, int soapPort) {
		return null;
	}

}
