/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.extractor.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.util.Guid;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#isContainsLineBreaks <em>Contains Line Breaks</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#getEndPattern <em>End Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#isIncludeEndPattern <em>Include End Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#isIncludeStartPattern <em>Include Start Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#getLineBreakSymbol <em>Line Break Symbol</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#isReplaceLineBreaks <em>Replace Line Breaks</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#getStartPattern <em>Start Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorTypeImpl#getUniqueID <em>Unique ID</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ExtractorTypeImpl extends EObjectImpl implements ExtractorType {
	/**
	 * The default value of the '{@link #isContainsLineBreaks() <em>Contains Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isContainsLineBreaks()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CONTAINS_LINE_BREAKS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isContainsLineBreaks() <em>Contains Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isContainsLineBreaks()
	 * @generated
	 * @ordered
	 */
	protected boolean containsLineBreaks = CONTAINS_LINE_BREAKS_EDEFAULT;

	/**
	 * This is true if the Contains Line Breaks attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean containsLineBreaksESet = false;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getEndPattern() <em>End Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndPattern()
	 * @generated
	 * @ordered
	 */
	protected static final String END_PATTERN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEndPattern() <em>End Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndPattern()
	 * @generated
	 * @ordered
	 */
	protected String endPattern = END_PATTERN_EDEFAULT;

	/**
	 * The default value of the '{@link #isIncludeEndPattern() <em>Include End Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeEndPattern()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INCLUDE_END_PATTERN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIncludeEndPattern() <em>Include End Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeEndPattern()
	 * @generated
	 * @ordered
	 */
	protected boolean includeEndPattern = INCLUDE_END_PATTERN_EDEFAULT;

	/**
	 * This is true if the Include End Pattern attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean includeEndPatternESet = false;

	/**
	 * The default value of the '{@link #isIncludeStartPattern() <em>Include Start Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeStartPattern()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INCLUDE_START_PATTERN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIncludeStartPattern() <em>Include Start Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeStartPattern()
	 * @generated
	 * @ordered
	 */
	protected boolean includeStartPattern = INCLUDE_START_PATTERN_EDEFAULT;

	/**
	 * This is true if the Include Start Pattern attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean includeStartPatternESet = false;

	/**
	 * The default value of the '{@link #getLineBreakSymbol() <em>Line Break Symbol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineBreakSymbol()
	 * @generated
	 * @ordered
	 */
	protected static final String LINE_BREAK_SYMBOL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLineBreakSymbol() <em>Line Break Symbol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineBreakSymbol()
	 * @generated
	 * @ordered
	 */
	protected String lineBreakSymbol = LINE_BREAK_SYMBOL_EDEFAULT;

	/**
	 * The default value of the '{@link #isReplaceLineBreaks() <em>Replace Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReplaceLineBreaks()
	 * @generated
	 * @ordered
	 */
	protected static final boolean REPLACE_LINE_BREAKS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isReplaceLineBreaks() <em>Replace Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReplaceLineBreaks()
	 * @generated
	 * @ordered
	 */
	protected boolean replaceLineBreaks = REPLACE_LINE_BREAKS_EDEFAULT;

	/**
	 * This is true if the Replace Line Breaks attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean replaceLineBreaksESet = false;

	/**
	 * The default value of the '{@link #getStartPattern() <em>Start Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartPattern()
	 * @generated
	 * @ordered
	 */
	protected static final String START_PATTERN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStartPattern() <em>Start Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartPattern()
	 * @generated
	 * @ordered
	 */
	protected String startPattern = START_PATTERN_EDEFAULT;

	/**
	 * The default value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected static final String UNIQUE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected String uniqueID = UNIQUE_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected ExtractorTypeImpl() {
		super();
		uniqueID = (new Guid()).toString();		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtractorPackage.eINSTANCE.getExtractorType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isContainsLineBreaks() {
		return containsLineBreaks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContainsLineBreaks(boolean newContainsLineBreaks) {
		boolean oldContainsLineBreaks = containsLineBreaks;
		containsLineBreaks = newContainsLineBreaks;
		boolean oldContainsLineBreaksESet = containsLineBreaksESet;
		containsLineBreaksESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS, oldContainsLineBreaks, containsLineBreaks, !oldContainsLineBreaksESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetContainsLineBreaks() {
		boolean oldContainsLineBreaks = containsLineBreaks;
		boolean oldContainsLineBreaksESet = containsLineBreaksESet;
		containsLineBreaks = CONTAINS_LINE_BREAKS_EDEFAULT;
		containsLineBreaksESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ExtractorPackage.EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS, oldContainsLineBreaks, CONTAINS_LINE_BREAKS_EDEFAULT, oldContainsLineBreaksESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetContainsLineBreaks() {
		return containsLineBreaksESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEndPattern() {
		return endPattern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndPattern(String newEndPattern) {
		String oldEndPattern = endPattern;
		endPattern = newEndPattern;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__END_PATTERN, oldEndPattern, endPattern));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIncludeEndPattern() {
		return includeEndPattern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIncludeEndPattern(boolean newIncludeEndPattern) {
		boolean oldIncludeEndPattern = includeEndPattern;
		includeEndPattern = newIncludeEndPattern;
		boolean oldIncludeEndPatternESet = includeEndPatternESet;
		includeEndPatternESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_END_PATTERN, oldIncludeEndPattern, includeEndPattern, !oldIncludeEndPatternESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetIncludeEndPattern() {
		boolean oldIncludeEndPattern = includeEndPattern;
		boolean oldIncludeEndPatternESet = includeEndPatternESet;
		includeEndPattern = INCLUDE_END_PATTERN_EDEFAULT;
		includeEndPatternESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_END_PATTERN, oldIncludeEndPattern, INCLUDE_END_PATTERN_EDEFAULT, oldIncludeEndPatternESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetIncludeEndPattern() {
		return includeEndPatternESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIncludeStartPattern() {
		return includeStartPattern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIncludeStartPattern(boolean newIncludeStartPattern) {
		boolean oldIncludeStartPattern = includeStartPattern;
		includeStartPattern = newIncludeStartPattern;
		boolean oldIncludeStartPatternESet = includeStartPatternESet;
		includeStartPatternESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_START_PATTERN, oldIncludeStartPattern, includeStartPattern, !oldIncludeStartPatternESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetIncludeStartPattern() {
		boolean oldIncludeStartPattern = includeStartPattern;
		boolean oldIncludeStartPatternESet = includeStartPatternESet;
		includeStartPattern = INCLUDE_START_PATTERN_EDEFAULT;
		includeStartPatternESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_START_PATTERN, oldIncludeStartPattern, INCLUDE_START_PATTERN_EDEFAULT, oldIncludeStartPatternESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetIncludeStartPattern() {
		return includeStartPatternESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLineBreakSymbol() {
		return lineBreakSymbol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineBreakSymbol(String newLineBreakSymbol) {
		String oldLineBreakSymbol = lineBreakSymbol;
		lineBreakSymbol = newLineBreakSymbol;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__LINE_BREAK_SYMBOL, oldLineBreakSymbol, lineBreakSymbol));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isReplaceLineBreaks() {
		return replaceLineBreaks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReplaceLineBreaks(boolean newReplaceLineBreaks) {
		boolean oldReplaceLineBreaks = replaceLineBreaks;
		replaceLineBreaks = newReplaceLineBreaks;
		boolean oldReplaceLineBreaksESet = replaceLineBreaksESet;
		replaceLineBreaksESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__REPLACE_LINE_BREAKS, oldReplaceLineBreaks, replaceLineBreaks, !oldReplaceLineBreaksESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetReplaceLineBreaks() {
		boolean oldReplaceLineBreaks = replaceLineBreaks;
		boolean oldReplaceLineBreaksESet = replaceLineBreaksESet;
		replaceLineBreaks = REPLACE_LINE_BREAKS_EDEFAULT;
		replaceLineBreaksESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ExtractorPackage.EXTRACTOR_TYPE__REPLACE_LINE_BREAKS, oldReplaceLineBreaks, REPLACE_LINE_BREAKS_EDEFAULT, oldReplaceLineBreaksESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetReplaceLineBreaks() {
		return replaceLineBreaksESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getStartPattern() {
		return startPattern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartPattern(String newStartPattern) {
		String oldStartPattern = startPattern;
		startPattern = newStartPattern;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__START_PATTERN, oldStartPattern, startPattern));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUniqueID() {
		return uniqueID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUniqueID(String newUniqueID) {
		String oldUniqueID = uniqueID;
		uniqueID = newUniqueID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtractorPackage.EXTRACTOR_TYPE__UNIQUE_ID, oldUniqueID, uniqueID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtractorPackage.EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS:
				return isContainsLineBreaks() ? Boolean.TRUE : Boolean.FALSE;
			case ExtractorPackage.EXTRACTOR_TYPE__DESCRIPTION:
				return getDescription();
			case ExtractorPackage.EXTRACTOR_TYPE__END_PATTERN:
				return getEndPattern();
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_END_PATTERN:
				return isIncludeEndPattern() ? Boolean.TRUE : Boolean.FALSE;
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_START_PATTERN:
				return isIncludeStartPattern() ? Boolean.TRUE : Boolean.FALSE;
			case ExtractorPackage.EXTRACTOR_TYPE__LINE_BREAK_SYMBOL:
				return getLineBreakSymbol();
			case ExtractorPackage.EXTRACTOR_TYPE__REPLACE_LINE_BREAKS:
				return isReplaceLineBreaks() ? Boolean.TRUE : Boolean.FALSE;
			case ExtractorPackage.EXTRACTOR_TYPE__START_PATTERN:
				return getStartPattern();
			case ExtractorPackage.EXTRACTOR_TYPE__UNIQUE_ID:
				return getUniqueID();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtractorPackage.EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS:
				setContainsLineBreaks(((Boolean)newValue).booleanValue());
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__END_PATTERN:
				setEndPattern((String)newValue);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_END_PATTERN:
				setIncludeEndPattern(((Boolean)newValue).booleanValue());
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_START_PATTERN:
				setIncludeStartPattern(((Boolean)newValue).booleanValue());
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__LINE_BREAK_SYMBOL:
				setLineBreakSymbol((String)newValue);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__REPLACE_LINE_BREAKS:
				setReplaceLineBreaks(((Boolean)newValue).booleanValue());
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__START_PATTERN:
				setStartPattern((String)newValue);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtractorPackage.EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS:
				unsetContainsLineBreaks();
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__END_PATTERN:
				setEndPattern(END_PATTERN_EDEFAULT);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_END_PATTERN:
				unsetIncludeEndPattern();
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_START_PATTERN:
				unsetIncludeStartPattern();
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__LINE_BREAK_SYMBOL:
				setLineBreakSymbol(LINE_BREAK_SYMBOL_EDEFAULT);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__REPLACE_LINE_BREAKS:
				unsetReplaceLineBreaks();
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__START_PATTERN:
				setStartPattern(START_PATTERN_EDEFAULT);
				return;
			case ExtractorPackage.EXTRACTOR_TYPE__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtractorPackage.EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS:
				return isSetContainsLineBreaks();
			case ExtractorPackage.EXTRACTOR_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case ExtractorPackage.EXTRACTOR_TYPE__END_PATTERN:
				return END_PATTERN_EDEFAULT == null ? endPattern != null : !END_PATTERN_EDEFAULT.equals(endPattern);
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_END_PATTERN:
				return isSetIncludeEndPattern();
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_START_PATTERN:
				return isSetIncludeStartPattern();
			case ExtractorPackage.EXTRACTOR_TYPE__LINE_BREAK_SYMBOL:
				return LINE_BREAK_SYMBOL_EDEFAULT == null ? lineBreakSymbol != null : !LINE_BREAK_SYMBOL_EDEFAULT.equals(lineBreakSymbol);
			case ExtractorPackage.EXTRACTOR_TYPE__REPLACE_LINE_BREAKS:
				return isSetReplaceLineBreaks();
			case ExtractorPackage.EXTRACTOR_TYPE__START_PATTERN:
				return START_PATTERN_EDEFAULT == null ? startPattern != null : !START_PATTERN_EDEFAULT.equals(startPattern);
			case ExtractorPackage.EXTRACTOR_TYPE__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (containsLineBreaks: ");
		if (containsLineBreaksESet) result.append(containsLineBreaks); else result.append("<unset>");
		result.append(", description: ");
		result.append(description);
		result.append(", endPattern: ");
		result.append(endPattern);
		result.append(", includeEndPattern: ");
		if (includeEndPatternESet) result.append(includeEndPattern); else result.append("<unset>");
		result.append(", includeStartPattern: ");
		if (includeStartPatternESet) result.append(includeStartPattern); else result.append("<unset>");
		result.append(", lineBreakSymbol: ");
		result.append(lineBreakSymbol);
		result.append(", replaceLineBreaks: ");
		if (replaceLineBreaksESet) result.append(replaceLineBreaks); else result.append("<unset>");
		result.append(", startPattern: ");
		result.append(startPattern);
		result.append(", uniqueID: ");
		result.append(uniqueID);
		result.append(')');
		return result.toString();
	}

} //ExtractorTypeImpl
