/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.outputter.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.*;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class OutputterFactoryImpl extends EFactoryImpl implements OutputterFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE_TYPE: return createLoggingAgentOutputterTypeType();
			case OutputterPackage.NOTIFICATION_OUTPUTTER_TYPE_TYPE: return createNotificationOutputterTypeType();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE: return createOutputterConfigType();
			case OutputterPackage.SINGLE_FILE_OUTPUTTER_TYPE_TYPE: return createSingleFileOutputterTypeType();
			case OutputterPackage.STANDARD_OUT_OUTPUTTER_TYPE_TYPE: return createStandardOutOutputterTypeType();
			case OutputterPackage.DOCUMENT_ROOT: return createDocumentRoot();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case OutputterPackage.OUTPUTTER_TYPE:
				return OutputterType.get(initialValue);
			case OutputterPackage.OUTPUTTER_TYPE_OBJECT:
				return createOutputterTypeObjectFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case OutputterPackage.OUTPUTTER_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case OutputterPackage.OUTPUTTER_TYPE_OBJECT:
				return convertOutputterTypeObjectToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LoggingAgentOutputterTypeType createLoggingAgentOutputterTypeType() {
		LoggingAgentOutputterTypeTypeImpl loggingAgentOutputterTypeType = new LoggingAgentOutputterTypeTypeImpl();
		return loggingAgentOutputterTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationOutputterTypeType createNotificationOutputterTypeType() {
		NotificationOutputterTypeTypeImpl notificationOutputterTypeType = new NotificationOutputterTypeTypeImpl();
		return notificationOutputterTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterConfigType createOutputterConfigType() {
		OutputterConfigTypeImpl outputterConfigType = new OutputterConfigTypeImpl();
		return outputterConfigType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SingleFileOutputterTypeType createSingleFileOutputterTypeType() {
		SingleFileOutputterTypeTypeImpl singleFileOutputterTypeType = new SingleFileOutputterTypeTypeImpl();
		return singleFileOutputterTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StandardOutOutputterTypeType createStandardOutOutputterTypeType() {
		StandardOutOutputterTypeTypeImpl standardOutOutputterTypeType = new StandardOutOutputterTypeTypeImpl();
		return standardOutOutputterTypeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentRoot createDocumentRoot() {
		DocumentRootImpl documentRoot = new DocumentRootImpl();
		return documentRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterType createOutputterTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (OutputterType)OutputterFactory.eINSTANCE.createFromString(OutputterPackage.eINSTANCE.getOutputterType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertOutputterTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return OutputterFactory.eINSTANCE.convertToString(OutputterPackage.eINSTANCE.getOutputterType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterPackage getOutputterPackage() {
		return (OutputterPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static OutputterPackage getPackage() {
		return OutputterPackage.eINSTANCE;
	}
} //OutputterFactoryImpl
