/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.sensor;

import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Config Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 *              A sensor consists of some space
 *                 control related attributes and a single
 *                 specific sensor implementation.    A sensor is a
 *                 processing unit aka             component and has those
 *                 implied attributes as well.             Sensor
 *                 parameters are specified as sensor             property
 *                 elements called SensorProperty.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getSingleFileSensor <em>Single File Sensor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getAdapterCBESensor <em>Adapter CBE Sensor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getStaticParserSensor <em>Static Parser Sensor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getMaximumBlocking <em>Maximum Blocking</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getSensorConfigType()
 * @model 
 * @generated
 */
public interface SensorConfigType extends ProcessUnitType{
	/**
	 * Returns the value of the '<em><b>Single File Sensor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Single File Sensor</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Single File Sensor</em>' containment reference.
	 * @see #setSingleFileSensor(SingleFileSensorType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getSensorConfigType_SingleFileSensor()
	 * @model containment="true"
	 * @generated
	 */
	SingleFileSensorType getSingleFileSensor();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getSingleFileSensor <em>Single File Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Single File Sensor</em>' containment reference.
	 * @see #getSingleFileSensor()
	 * @generated
	 */
	void setSingleFileSensor(SingleFileSensorType value);

	/**
	 * Returns the value of the '<em><b>Adapter CBE Sensor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Adapter CBE Sensor</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Adapter CBE Sensor</em>' containment reference.
	 * @see #setAdapterCBESensor(AdapterCBESensorType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getSensorConfigType_AdapterCBESensor()
	 * @model containment="true"
	 * @generated
	 */
	AdapterCBESensorType getAdapterCBESensor();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getAdapterCBESensor <em>Adapter CBE Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Adapter CBE Sensor</em>' containment reference.
	 * @see #getAdapterCBESensor()
	 * @generated
	 */
	void setAdapterCBESensor(AdapterCBESensorType value);

	/**
	 * Returns the value of the '<em><b>Static Parser Sensor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Static Parser Sensor</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Static Parser Sensor</em>' containment reference.
	 * @see #setStaticParserSensor(StaticParserSensorType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getSensorConfigType_StaticParserSensor()
	 * @model containment="true"
	 * @generated
	 */
	StaticParserSensorType getStaticParserSensor();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getStaticParserSensor <em>Static Parser Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Static Parser Sensor</em>' containment reference.
	 * @see #getStaticParserSensor()
	 * @generated
	 */
	void setStaticParserSensor(StaticParserSensorType value);

	/**
	 * Returns the value of the '<em><b>Maximum Blocking</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 *                             maximumBlocking is used to determine how
	 *                             many records can be
	 *                             passed out of the sensor. For example a
	 *                             value of 5 implies that
	 *                             5 or less records can be provided in one
	 *                             call to a sensor.                       This
	 *                             is an important tuning feature because large
	 *                             blocks                       reduce context
	 *                             flow overhead, yet also often require more memory.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Maximum Blocking</em>' attribute.
	 * @see #setMaximumBlocking(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getSensorConfigType_MaximumBlocking()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getMaximumBlocking();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getMaximumBlocking <em>Maximum Blocking</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Maximum Blocking</em>' attribute.
	 * @see #getMaximumBlocking()
	 * @generated
	 */
	void setMaximumBlocking(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType
	 * @see #isSetType()
	 * @see #unsetType()
	 * @see #setType(SensorType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getSensorConfigType_Type()
	 * @model unique="false" unsettable="true" required="true"
	 * @generated
	 */
	SensorType getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType
	 * @see #isSetType()
	 * @see #unsetType()
	 * @see #getType()
	 * @generated
	 */
	void setType(SensorType value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetType()
	 * @see #getType()
	 * @see #setType(SensorType)
	 * @generated
	 */
	void unsetType();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType#getType <em>Type</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Type</em>' attribute is set.
	 * @see #unsetType()
	 * @see #getType()
	 * @see #setType(SensorType)
	 * @generated
	 */
	boolean isSetType();

} // SensorConfigType
