/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.sensor;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Static Parser Sensor Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 *      A sensor that runs a static parser to
 *                 parse a log file.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType#getDirectory <em>Directory</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType#getFileName <em>File Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType#getParserClassName <em>Parser Class Name</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getStaticParserSensorType()
 * @model 
 * @generated
 */
public interface StaticParserSensorType extends SensorBaseType {
	/**
	 * Returns the value of the '<em><b>Directory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 *       The directory path of the input
	 *                     file that will be      read.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Directory</em>' attribute.
	 * @see #setDirectory(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getStaticParserSensorType_Directory()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getDirectory();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType#getDirectory <em>Directory</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Directory</em>' attribute.
	 * @see #getDirectory()
	 * @generated
	 */
	void setDirectory(String value);

	/**
	 * Returns the value of the '<em><b>File Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 *       The name of the input file that
	 *                     will be      read.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>File Name</em>' attribute.
	 * @see #setFileName(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getStaticParserSensorType_FileName()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getFileName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType#getFileName <em>File Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>File Name</em>' attribute.
	 * @see #getFileName()
	 * @generated
	 */
	void setFileName(String value);

	/**
	 * Returns the value of the '<em><b>Parser Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 *         The full class name of
	 *                             the static parser that will        be
	 *                             executed.  The name must include the package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Parser Class Name</em>' attribute.
	 * @see #setParserClassName(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage#getStaticParserSensorType_ParserClassName()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getParserClassName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType#getParserClassName <em>Parser Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parser Class Name</em>' attribute.
	 * @see #getParserClassName()
	 * @generated
	 */
	void setParserClassName(String value);

} // StaticParserSensorType
