/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 *
 */
public class ImportWizardRadioButton implements IImportWizardWidget {

	protected Collection buttonList = new ArrayList();
	private ParserField _field = null;
	
	
	/**
	 * Constructor
	 * 
	 * @param field - The parser field used to create this object 
	 */
	public ImportWizardRadioButton (ParserField field)
	{
		_field = field;
	}
	
	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#getValue()
	 */
	public String getValue() {
		Iterator iter = buttonList.iterator();
		while (iter.hasNext()){
			Button button = (Button)iter.next();
			if (button.getSelection())
				return button.getText();
		}
		return null;
	}

	public void setValue(String newValue){

		Iterator iter = buttonList.iterator();
		StringTokenizer st = new StringTokenizer(newValue,",");
		String token = "";
		while(iter.hasNext()&&st.hasMoreTokens()){
			Button button = (Button)iter.next();
			token = st.nextToken();
			button.setSelection(token.equals("true"));
		}
	
	}
	
	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#createControl(Composite, ParserField, String)
	 */
	public void createControl(
		Composite composite,
		String prefix) {
        Label label = new Label(composite, SWT.NULL | SWT.WRAP);            
        GridData data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;    
        label.setLayoutData(data);
        label.setText(_field.getName());
            
        // Get the previous value from the preference store, if one exists.
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
            
        String previousValue = store.getString(prefix + _field.getId());
                	
       	//parse previousValue.  This value should be a list of comma separated values
       	StringTokenizer st = new StringTokenizer(_field.getDefaultValue(),",");       	
       	int index = 0;
       	while(st.hasMoreTokens()){
       		String token = st.nextToken();
			Button radio = new Button(composite, SWT.RADIO);
            Point buttonSize = radio.computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
       		data = new GridData();
	        data.widthHint = 400;
    	    data.horizontalSpan = 2;    
	        radio.setLayoutData(data);
	        radio.setToolTipText(_field.getTooltip());            
            
			radio.setText(token);
       		if ((previousValue != null) && (previousValue.trim().equals(token)))
       			radio.setSelection(true);
			else{
				//if no default value use the first value as the default value
				if (((previousValue == null) || previousValue.trim().equals("")) && (index == 0))
	       			radio.setSelection(true);
				else			
					radio.setSelection(false);
			}
				
			index++;
			buttonList.add(radio);
       	}   
			
	}

	/**
	 * Returns the buttonList.
	 * @return Collection
	 */
	public Collection getButtonList() {
		return buttonList;
	}

	/**
	 * Sets the buttonList.
	 * @param buttonList The buttonList to set
	 */
	public void setButtonList(Collection buttonList) {
		this.buttonList = buttonList;
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#isValid()
	 */
	public boolean isValid() {
		return true;
	}

	/**
	 * Returns the parser field used to instantiate an object of this class
	 *
	 */
	public ParserField getField()
	{
		return _field;
	}
}
