/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Aug 7, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;

/**
 * @author apnan
 *
 */
public class LogFileElement {

	private String host;
	private String project;    
	private String monitor;
	private TRCAgentProxy mergedAgent;
	private List values = new ArrayList();
	private LogParserItem parser;
	private boolean isValid;
	private boolean useLargeLogSupport;
	
	/**
	 * 
	 */
	public LogFileElement() {
		super();

	}

	/**
	 * @return
	 */
	public TRCAgentProxy getMergedAgent() {
		return mergedAgent;
	}

	/**
	 * @return
	 */
	public String getMonitor() {
		return monitor;
	}

	/**
	 * @return
	 */
	public String getProject() {
		return project;
	}

	/**
	 * @return
	 */
	public List getValues() {
		return values;
	}

	/**
	 * @param proxy
	 */
	public void setMergedAgent(TRCAgentProxy proxy) {
		mergedAgent = proxy;
	}

	/**
	 * @param string
	 */
	public void setMonitor(String string) {
		monitor = string;
	}

	/**
	 * @param string
	 */
	public void setProject(String string) {
		project = string;
	}


	/**
	 * @return
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param string
	 */
	public void setHost(String string) {
		host = string;
	}

	/**
	 * @return
	 */
	public LogParserItem getParser() {
		return parser;
	}

	/**
	 * @param item
	 */
	public void setParser(LogParserItem item) {
		parser = item;
	}

	/**
	 * @return
	 */
	public boolean isValid() {
		return isValid;
	}

	/**
	 * @param b
	 */
	public void setValid(boolean b) {
		isValid = b;
	}

	/**
	 * @return Returns the useLargeLogSupport.
	 */
	public boolean isUseLargeLogSupport() {
		return useLargeLogSupport;
	}

	/**
	 * @param useLargeLogSupport The useLargeLogSupport to set.
	 */
	public void setUseLargeLogSupport(boolean useLargeLogSupport) {
		this.useLargeLogSupport = useLargeLogSupport;
	}

}
